/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.inventory;

import ic2.api.classic.network.INetworkFieldData;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.IInventoryModifier;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.item.inv.inventories.InventorySlotAccessModifier;
import ic2.core.item.upgrades.subtypes.inventory.BaseMetaInventoryUpgrade;
import ic2.core.network.fieldEvents.item.SlotTypeModifierFieldData;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotAccessModifierUpgrade
extends BaseMetaInventoryUpgrade
implements IHandHeldInventory {
    @Override
    public IInventoryModifier.EffectType getEffect() {
        return IInventoryModifier.EffectType.Slot;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return Ic2Icons.getTextures("i1")[164];
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.slotAccessUpgrade;
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new InventorySlotAccessModifier(stack, hand);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean adv, Map<ToolTipType, List<String>> sortedToolTips) {
        super.addInformation(stack, player, list, adv, sortedToolTips);
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (!nbt.func_74767_n("Loaded")) {
            return;
        }
        List<String> altList = sortedToolTips.get((Object)ToolTipType.Alt);
        HashMap<Integer, AccessRule[]> sorted = new HashMap<Integer, AccessRule[]>();
        AccessRule[] array = AccessRule.values();
        NBTTagList nbtList = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound data = nbtList.func_150305_b(i);
            int slot = data.func_74762_e("ID");
            NBTTagList map = data.func_150295_c("Rules", 7);
            AccessRule[] result = new AccessRule[6];
            for (int x = 0; x < map.func_74745_c(); ++x) {
                byte[] bytes = ((NBTTagByteArray)map.func_179238_g(x)).func_150292_c();
                result[bytes[0]] = array[bytes[1]];
            }
            sorted.put(slot, result);
        }
        for (Map.Entry entry : sorted.entrySet()) {
            AccessRule[] rules = (AccessRule[])entry.getValue();
            altList.add(Ic2InfoLang.invUpgradeSlotAccesses.getLocalizedFormatted(entry.getKey(), rules[0].getName(), rules[1].getName(), rules[2].getName(), rules[3].getName(), rules[4].getName(), rules[5].getName()));
        }
    }

    @Override
    public void onInstalling(ItemStack stack, IHasHandler.IInventoryHandler handler) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        if (!nbt.func_74767_n("Loaded")) {
            return;
        }
        if (!nbt.func_74779_i("ID").equals(handler.getInventoryID())) {
            return;
        }
        AccessRule[] array = AccessRule.values();
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("ID");
            NBTTagList map = data.func_150295_c("Rules", 7);
            for (int x = 0; x < map.func_74745_c(); ++x) {
                byte[] bytes = ((NBTTagByteArray)map.func_179238_g(x)).func_150292_c();
                handler.setAccessRuleForSlots(RotationList.ofFacings(EnumFacing.field_82609_l[bytes[0]]), array[bytes[1]], slot);
            }
        }
    }

    @Override
    public void onNetworkEvent(ItemStack networkStack, EntityPlayer player, INetworkFieldData data) {
        if (!(data instanceof SlotTypeModifierFieldData)) {
            return;
        }
        SlotTypeModifierFieldData slotData = (SlotTypeModifierFieldData)data;
        ItemStack stack = player.func_184586_b(slotData.isOffHand() ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        if (!StackUtil.isStackEqual(networkStack, stack)) {
            return;
        }
        NBTTagList list = new NBTTagList();
        Map<Integer, AccessRule> masterMap = slotData.getMasterRules();
        for (Map.Entry<Integer, Map<EnumFacing, AccessRule>> map : slotData.getData().entrySet()) {
            Integer slot = map.getKey();
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("ID", slot.byteValue());
            Map<EnumFacing, AccessRule> rules = map.getValue();
            nbt.func_74774_a("Master", (byte)masterMap.get(slot).ordinal());
            NBTTagList dataList = new NBTTagList();
            for (Map.Entry<EnumFacing, AccessRule> entry : rules.entrySet()) {
                dataList.func_74742_a((NBTBase)new NBTTagByteArray(new byte[]{(byte)entry.getKey().func_176745_a(), (byte)entry.getValue().ordinal()}));
            }
            nbt.func_74782_a("Rules", (NBTBase)dataList);
            list.func_74742_a((NBTBase)nbt);
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74782_a("Data", (NBTBase)list);
        IC2.platform.messagePlayer(player, Ic2InfoLang.machineToolSavedData);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public ActionResult<ItemStack> onRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K || player.func_70093_af()) {
            return super.onRightClick(stack, world, player, hand);
        }
        if (!StackUtil.getOrCreateNbtData(stack).func_74767_n("Loaded")) {
            IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeNeedsBound);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        IC2.platform.launchGui(player, this.getInventory(player, hand, stack), hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean hasBlockClick() {
        return true;
    }

    @Override
    public EnumActionResult onBlockClick(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K || !player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHasHandler) {
            IHasHandler handler = (IHasHandler)tile;
            InventoryHandler inv = handler.getHandler();
            if (inv == null || !inv.canModifySlots()) {
                IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeBoundFailed);
                return EnumActionResult.FAIL;
            }
            this.readFromBlock(stack, inv);
            IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeBoundSuccess);
            return EnumActionResult.SUCCESS;
        }
        return super.onBlockClick(stack, world, pos, side, player, hand);
    }

    private void readFromBlock(ItemStack stack, InventoryHandler handler) {
        List<Integer> slots = handler.getAllSlots();
        NBTTagList list = new NBTTagList();
        for (Integer slot : slots) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("ID", slot.byteValue());
            Map<EnumFacing, AccessRule> rules = handler.getSlotRules(slot);
            nbt.func_74774_a("Master", (byte)handler.getMasterSlotRule(slot).ordinal());
            NBTTagList data = new NBTTagList();
            for (Map.Entry<EnumFacing, AccessRule> entry : rules.entrySet()) {
                data.func_74742_a((NBTBase)new NBTTagByteArray(new byte[]{(byte)entry.getKey().ordinal(), (byte)entry.getValue().ordinal()}));
            }
            nbt.func_74782_a("Rules", (NBTBase)data);
            list.func_74742_a((NBTBase)nbt);
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74782_a("Data", (NBTBase)list);
        nbt.func_74757_a("Loaded", true);
        nbt.func_74778_a("ID", handler.getInventoryID());
    }
}

