/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.recipe.IRecipeInput;
import ic2.core.Direction;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.filters.TupleFilter;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.upgrades.subtypes.machine.BaseFilteredUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.Ic2Icons;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FilteredBasicImportUpgrade
extends BaseFilteredUpgrade {
    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        if (!machine.isProcessing() && this.getWorldTime(machine) % 20L == 0L) {
            this.importItems(upgrade, machine);
        }
    }

    public void importItems(ItemStack upgrade, IMachine machine) {
        TileEntity tile;
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyTo(machine.getMachineWorld(), machine.getMachinePos())) != null) {
            ItemStack added;
            ItemStack stack;
            IItemTransporter mach = TransporterManager.manager.getTransporter(machine, true);
            IItemTransporter target = TransporterManager.manager.getTransporter(this.getInventory(upgrade, tile), true);
            if (mach == null || target == null) {
                return;
            }
            TupleFilter filter = new TupleFilter(this.getFilter(upgrade), new MachineFilter(machine));
            int max = Math.min(9, upgrade.func_190916_E());
            for (int i = 0; i < max && !(stack = target.removeItem(filter, dir.getInverse().toFacing(), 1, false)).func_190926_b() && (added = mach.addItem(stack, dir.toFacing(), true)).func_190916_E() > 0; ++i) {
                target.removeItem(filter, dir.getInverse().toFacing(), added.func_190916_E(), true);
            }
        }
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public void onProcessFinished(ItemStack upgrade, IMachine machine) {
        this.importItems(upgrade, machine);
    }

    @Override
    public void onProcessEndPost(ItemStack upgrade, IMachine machine, IRecipeInput input, MachineOutput output, List<IStackOutput> items) {
        TileEntity tile;
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyTo(machine.getMachineWorld(), machine.getMachinePos())) != null) {
            ItemStack added;
            ItemStack stack;
            IItemTransporter mach = TransporterManager.manager.getTransporter(machine, true);
            IItemTransporter target = TransporterManager.manager.getTransporter(this.getInventory(upgrade, tile), true);
            if (mach == null || target == null) {
                return;
            }
            int max = Math.min(9, upgrade.func_190916_E());
            TupleFilter filter = new TupleFilter(this.getFilter(upgrade), new MachineFilter(machine));
            for (int i = 0; i < max && !(stack = target.removeItem(filter, dir.getInverse().toFacing(), 1, false)).func_190926_b() && (added = mach.addItem(stack, dir.toFacing(), true)).func_190916_E() > 0; ++i) {
                target.removeItem(filter, dir.getInverse().toFacing(), added.func_190916_E(), true);
            }
        }
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.ImportExport;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[152];
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.basicFilteredImportUpgrade;
    }

    @Override
    public boolean usesOwner() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }
}

