/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.registry;

import com.google.common.base.Strings;
import ic2.api.classic.item.IClassicItemAPI;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemAPI
implements IClassicItemAPI {
    public static ItemAPI instance = new ItemAPI();
    Map<String, ItemStack> items = new HashMap<String, ItemStack>();
    Map<ResourceLocation, ItemStack> stacks = new HashMap<ResourceLocation, ItemStack>();
    Map<String, IBlockState> blocks = new HashMap<String, IBlockState>();
    Map<ResourceLocation, IBlockState> states = new HashMap<ResourceLocation, IBlockState>();

    @Override
    public IBlockState getBlockState(String name, String variant) {
        if (Strings.isNullOrEmpty((String)variant)) {
            IBlockState state = this.blocks.get(name);
            if (state == null) {
                state = this.getAir();
                this.blocks.put(name, state);
            }
            return state;
        }
        ResourceLocation location = new ResourceLocation(name, variant);
        IBlockState state = this.states.get(location);
        if (state == null) {
            state = this.getAir();
            this.states.put(location, state);
        }
        return state;
    }

    @Override
    public ItemStack getItemStack(String name, String variant) {
        if (Strings.isNullOrEmpty((String)variant)) {
            ItemStack stack = this.items.get(name == null ? null : name.toLowerCase(Locale.ENGLISH));
            if (stack == null) {
                stack = this.getNoUse();
                this.items.put(name, stack);
            }
            return stack;
        }
        ResourceLocation location = new ResourceLocation(name, variant);
        ItemStack stack = this.stacks.get(location);
        if (stack == null) {
            stack = this.getNoUse();
            this.stacks.put(location, stack);
        }
        return stack;
    }

    @Override
    public Block getBlock(String name) {
        IBlockState state = this.blocks.get(name);
        if (state != null) {
            return state.func_177230_c();
        }
        return this.getAir().func_177230_c();
    }

    @Override
    public Item getItem(String name) {
        ItemStack stack = this.items.get(name);
        if (stack != null) {
            return stack.func_77973_b();
        }
        return this.getNoUse().func_77973_b();
    }

    public void init() {
        this.putItem("boat", Ic2Items.boatRubber);
        this.putItem("boat", "rubber", Ic2Items.boatRubber);
        this.putItem("boat", "broken_rubber", Ic2Items.boatRubberBroken);
        this.putItem("boat", "carbon", Ic2Items.boatCarbon);
        this.putItem("boat", "electric", Ic2Items.boatElectric);
        this.putList("crushed", Arrays.asList("copper", "gold", "iron", "lead", "silver", "tin", "uranium"), this.getNoUse());
        this.putList("purified", Arrays.asList("copper", "gold", "iron", "lead", "silver", "tin", "uranium"), this.getNoUse());
        this.putItem("dust", Ic2Items.ironDust);
        this.putItem("dust", "bronze", Ic2Items.bronzeDust);
        this.putItem("dust", "clay", Ic2Items.clayDust);
        this.putItem("dust", "coal", Ic2Items.coalDust);
        this.putItem("dust", "coal_fuel", Ic2Items.hydratedCoalDust);
        this.putItem("dust", "copper", Ic2Items.copperDust);
        this.putItem("dust", "gold", Ic2Items.goldDust);
        this.putItem("dust", "iron", Ic2Items.ironDust);
        this.putItem("dust", "small_iron", Ic2Items.ironDust);
        this.putItem("dust", "obsidian", Ic2Items.obsidianDust);
        this.putItem("dust", "silver", Ic2Items.silverDust);
        this.putItem("dust", "tin", Ic2Items.tinDust);
        this.putItem("dust", "silicon_dioxide", this.getNoUse());
        this.putItem("dust", "stone", this.getNoUse());
        this.putItem("dust", "sulfur", this.getNoUse());
        this.putItem("dust", "lapis", this.getNoUse());
        this.putItem("dust", "lead", this.getNoUse());
        this.putItem("dust", "lithium", this.getNoUse());
        this.putItem("dust", "diamond", this.getNoUse());
        this.putItem("dust", "small_bronze", this.getNoUse());
        this.putItem("dust", "small_copper", this.getNoUse());
        this.putItem("dust", "small_gold", this.getNoUse());
        this.putItem("dust", "small_lapis", this.getNoUse());
        this.putItem("dust", "small_lead", this.getNoUse());
        this.putItem("dust", "small_lithium", this.getNoUse());
        this.putItem("dust", "small_obsidian", this.getNoUse());
        this.putItem("dust", "small_silver", this.getNoUse());
        this.putItem("dust", "small_sulfur", this.getNoUse());
        this.putItem("dust", "small_tin", this.getNoUse());
        this.putItem("ingot", Ic2Items.refinedIronIngot);
        this.putItem("ingot", "refinedIron", Ic2Items.refinedIronIngot);
        this.putItem("ingot", "alloy", Ic2Items.mixedMetalIngot);
        this.putItem("ingot", "bronze", Ic2Items.bronzeIngot);
        this.putItem("ingot", "copper", Ic2Items.copperIngot);
        this.putItem("ingot", "silver", Ic2Items.silverIngot);
        this.putItem("ingot", "tin", Ic2Items.tinIngot);
        this.putItem("ingot", "steel", this.getNoUse());
        this.putItem("ingot", "lead", this.getNoUse());
        this.putList("plate", Arrays.asList("bronze", "copper", "gold", "iron", "lapis", "lead", "obsidian", "steel", "tin", "dense_bronze", "dense_gold", "dense_iron", "dense_lapis", "dense_lead", "dense_obsidian", "dense_steel", "dense_tin"), this.getNoUse());
        this.putItem("plate", "dense_copper", Ic2Items.denseCopperPlate);
        this.putList("casing", Arrays.asList("bronze", "copper", "gold", "iron", "lead", "steel", "tin"), this.getNoUse());
        this.putItem("nuclear", Ic2Items.reactorUraniumRodSingle);
        this.putItem("nuclear", "uranium", Ic2Items.uraniumIngot);
        this.putItem("nuclear", "uranium_235", Ic2Items.uraniumDrop);
        this.putItem("nuclear", "uranium_238", Ic2Items.uraniumDrop);
        this.putItem("nuclear", "depleted_uranium", Ic2Items.reactorNearDepletedUraniumRod);
        this.putItem("nuclear", "depleted_dual_uranium", StackUtil.copyWithSize(Ic2Items.reactorNearDepletedUraniumRod, 2));
        this.putItem("nuclear", "depleted_quad_uranium", StackUtil.copyWithSize(Ic2Items.reactorNearDepletedUraniumRod, 4));
        this.putItem("nuclear", "isotopic_cell_uranium", Ic2Items.reactorUraniumIsotopicRod);
        this.putItem("nuclear", "enriched_cell_uranium", Ic2Items.reactorReEnrichedUraniumRod);
        this.putItem("nuclear", "redstoneUranium", Ic2Items.redstoneUraniumIngot);
        this.putItem("nuclear", "depleted_redstoneUranium", Ic2Items.reactorNearDepletedRedstoneUraniumRod);
        this.putItem("nuclear", "isotopic_cell_redstoneUranium", Ic2Items.reactorRedstoneUraniumIsotopicRod);
        this.putItem("nuclear", "enriched_cell_redstoneUranium", Ic2Items.reactorReEnrichedRedstoneUraniumRod);
        this.putItem("nuclear", "blazeUranium", Ic2Items.blazeUraniumIngot);
        this.putItem("nuclear", "depleted_blazeUranium", Ic2Items.reactorNearDepletedBlazeUraniumRod);
        this.putItem("nuclear", "isotopic_cell_blazeUranium", Ic2Items.reactorBlazeUraniumIsotopicRod);
        this.putItem("nuclear", "enriched_cell_blazeUranium", Ic2Items.reactorReEnrichedBlazeUraniumRod);
        this.putItem("nuclear", "enderUranium", Ic2Items.enderPearlUraniumIngot);
        this.putItem("nuclear", "depleted_enderUranium", Ic2Items.reactorNearDepletedEnderPearlUraniumRod);
        this.putItem("nuclear", "isotopic_cell_enderUranium", Ic2Items.reactorEnderPearlUraniumIsotopicRod);
        this.putItem("nuclear", "enriched_cell_enderUranium", Ic2Items.reactorReEnrichedEnderPearlUraniumRod);
        this.putItem("nuclear", "netherStarUranium", Ic2Items.netherStarUraniumIngot);
        this.putItem("nuclear", "depleted_netherStarUranium", Ic2Items.reactorNearDepletedNetherStarUraniumRod);
        this.putItem("nuclear", "isotopic_cell_netherStarUranium", Ic2Items.reactorNetherStarUraniumIsotopicRod);
        this.putItem("nuclear", "enriched_cell_netherStarUranium", Ic2Items.reactorReEnrichedNetherStarUraniumRod);
        this.putItem("nuclear", "charcoalUranium", Ic2Items.charcoalUraniumIngot);
        this.putItem("nuclear", "depleted_charcoalUranium", Ic2Items.reactorNearDepletedCharcoalUraniumRod);
        this.putItem("nuclear", "isotopic_cell_charcoalUranium", Ic2Items.reactorCharcoalUraniumIsotopicRod);
        this.putItem("nuclear", "enriched_cell_charcoalUranium", Ic2Items.reactorReEnrichedCharcoalUraniumRod);
        this.putItem("nuclear", "plutonium", this.getNoUse());
        this.putItem("nuclear", "mox", this.getNoUse());
        this.putItem("nuclear", "small_uranium_235", this.getNoUse());
        this.putItem("nuclear", "small_uranium_238", this.getNoUse());
        this.putItem("nuclear", "small_plutonium", this.getNoUse());
        this.putItem("nuclear", "uranium_pellet", this.getNoUse());
        this.putItem("nuclear", "mox_pellet", this.getNoUse());
        this.putItem("nuclear", "rtg_pellet", this.getNoUse());
        this.putItem("nuclear", "depleted_mox", this.getNoUse());
        this.putItem("nuclear", "depleted_dual_mox", this.getNoUse());
        this.putItem("nuclear", "depleted_quad_mox", this.getNoUse());
        this.putItem("misc_resource", Ic2Items.iridiumOre);
        this.putItem("misc_resource", "iridium_ore", Ic2Items.iridiumOre);
        this.putItem("misc_resource", "matter", Ic2Items.uuMatter);
        this.putItem("misc_resource", "resin", Ic2Items.stickyResin);
        this.putItem("misc_resource", "ashes", this.getNoUse());
        this.putItem("misc_resource", "slag", this.getNoUse());
        this.putItem("misc_resource", "iridium_shard", this.getNoUse());
        this.putList("block_cutting_blade", Arrays.asList("iron", "steel", "diamond"), this.getNoUse());
        this.putItem("crafting", Ic2Items.rubber);
        this.putItem("crafting", "rubber", Ic2Items.rubber);
        this.putItem("crafting", "circuit", Ic2Items.electricCircuit);
        this.putItem("crafting", "advanced_circuit", Ic2Items.advancedCircuit);
        this.putItem("crafting", "alloy", Ic2Items.advancedAlloy);
        this.putItem("crafting", "iridium", Ic2Items.iridiumPlate);
        this.putItem("crafting", "coil", this.getNoUse());
        this.putItem("crafting", "electric_motor", this.getNoUse());
        this.putItem("crafting", "heat_conductor", this.getNoUse());
        this.putItem("crafting", "copper_boiler", this.getNoUse());
        this.putItem("crafting", "fuel_rod", this.getNoUse());
        this.putItem("crafting", "tin_can", Ic2Items.tinCan);
        this.putItem("crafting", "fuel_can", Ic2Items.fuelCan);
        this.putItem("crafting", "fuel_can_full", Ic2Items.fullFuelCan);
        this.putItem("crafting", "small_power_unit", this.getNoUse());
        this.putItem("crafting", "power_unit", this.getNoUse());
        this.putItem("crafting", "carbon_fibre", Ic2Items.carbonFiber);
        this.putItem("crafting", "carbon_mesh", Ic2Items.carbonMesh);
        this.putItem("crafting", "carbon_plate", Ic2Items.carbonPlate);
        this.putItem("crafting", "coal_ball", Ic2Items.coalBall);
        this.putItem("crafting", "coal_block", Ic2Items.compressedCoalBall);
        this.putItem("crafting", "coal_chunk", Ic2Items.coalChunk);
        this.putItem("crafting", "industrial_diamond", Ic2Items.industrialDiamond);
        this.putItem("crafting", "plant_ball", Ic2Items.plantBall);
        this.putItem("crafting", "plant_ball_compressed", Ic2Items.compressedPlantBall);
        this.putItem("crafting", "bio_chaff", this.getNoUse());
        this.putItem("crafting", "compressed_hydrated_coal", Ic2Items.hydratedCoalClump);
        this.putItem("crafting", "scrap", Ic2Items.scrap);
        this.putItem("crafting", "scrap_box", Ic2Items.scrapBox);
        this.putItem("crafting", "scrap_metal", Ic2Items.scrapMetal);
        this.putItem("crafting", "cf_powder", this.getNoUse());
        this.putItem("crafting", "pellet", Ic2Items.constructionFoamPellet);
        this.putItem("crafting", "raw_crystal_memory", this.getNoUse());
        this.putItem("crafting", "iron_shaft", this.getNoUse());
        this.putItem("crafting", "wood_rotor_blade", this.getNoUse());
        this.putItem("crafting", "iron_rotor_blade", this.getNoUse());
        this.putItem("crafting", "steel_rotor_blade", this.getNoUse());
        this.putItem("crafting", "carbon_rotor_blade", this.getNoUse());
        this.putItem("crafting", "steam_turbine_blade", this.getNoUse());
        this.putItem("crafting", "steam_turbine", this.getNoUse());
        this.putItem("crafting", "scrap_metal_chunk", Ic2Items.scrapMetalChunk);
        this.putItem("crafting", "scrap_metal_blade", Ic2Items.scrapMetalBlade);
        this.putItem("crafting", "obsidian_blade_raw", Ic2Items.rawObsidianBlade);
        this.putItem("crafting", "obsidian_blade", Ic2Items.obsidianBlade);
        this.putItem("crystal_memory", this.getNoUse());
        this.putItem("upgrade_kit", Ic2Items.mfsuUpgradeKid);
        this.putItem("upgrade_kit", "mfsu", Ic2Items.mfsuUpgradeKid);
        this.putItem("crop_res", Ic2Items.coffeeBeans);
        this.putItem("crop_res", "coffee_beans", Ic2Items.coffeeBeans);
        this.putItem("crop_res", "coffee_powder", Ic2Items.coffeePowder);
        this.putItem("crop_res", "fertilizer", Ic2Items.fertilizer);
        this.putItem("crop_res", "fertilizer_overgrowth", Ic2Items.overgrowthFertilizer);
        this.putItem("crop_res", "grin_powder", Ic2Items.grinPowder);
        this.putItem("crop_res", "hops", Ic2Items.hops);
        this.putItem("crop_res", "tea", Ic2Items.teaLeaf);
        this.putItem("crop_res", "cropSeed", Ic2Items.cropSeed);
        this.putItem("crop_res", "weed", this.getNoUse());
        this.putItem("terra_wart", Ic2Items.terraWart);
        this.putItem("flour", Ic2Items.flour);
        this.putItem("re_battery", Ic2Items.battery);
        this.putItem("advanced_re_battery", this.getNoUse());
        this.putItem("energy_crystal", Ic2Items.energyCrystal);
        this.putItem("lapotron_crystal", Ic2Items.lapotronCrystal);
        this.putItem("single_use_battery", Ic2Items.suBattery);
        this.putItem("charging_re_battery", Ic2Items.battery);
        this.putItem("advanced_charging_re_battery", this.getNoUse());
        this.putItem("charging_energy_crystal", this.getNoUse());
        this.putItem("charging_lapotron_crystal", this.getNoUse());
        this.putItem("heat_storage", Ic2Items.reactorCoolantCellSimple);
        this.putItem("tri_heat_storage", Ic2Items.reactorCoolantCellTriple);
        this.putItem("hex_heat_storage", Ic2Items.reactorCoolantCellSix);
        this.putItem("plating", Ic2Items.reactorPlating);
        this.putItem("heat_plating", Ic2Items.reactorPlatingHeat);
        this.putItem("containment_plating", Ic2Items.reactorPlatingExplosive);
        this.putItem("heat_pack", Ic2Items.reactorHeatPack);
        this.putItem("heat_exchanger", Ic2Items.reactorHeatSwitch);
        this.putItem("reactor_heat_exchanger", Ic2Items.reactorHeatSwitchCore);
        this.putItem("component_heat_exchanger", Ic2Items.reactorHeatSwitchGold);
        this.putItem("advanced_heat_exchanger", Ic2Items.reactorHeatSwitchDiamond);
        this.putItem("component_heat_vent", Ic2Items.reactorVentSpread);
        this.putItem("heat_vent", Ic2Items.reactorVent);
        this.putItem("reactor_heat_vent", Ic2Items.reactorVentCore);
        this.putItem("overclocked_heat_vent", Ic2Items.reactorVentGold);
        this.putItem("advanced_heat_vent", Ic2Items.reactorVentDiamond);
        this.putItem("steam_vent", Ic2Items.reactorSteamVent);
        this.putItem("reactor_steam_vent", Ic2Items.reactorSteamVentCore);
        this.putItem("overclocked_steam_vent", Ic2Items.reactorSteamVentGold);
        this.putItem("advanced_steam_vent", Ic2Items.reactorSteamVentDiamond);
        this.putItem("electric_vent", Ic2Items.reactorElectricVent);
        this.putItem("reactor_electric_vent", Ic2Items.reactorElectricVentCore);
        this.putItem("overclocked_electric_vent", Ic2Items.reactorElectricVentGold);
        this.putItem("advanced_electric_vent", Ic2Items.reactorElectricVentDiamond);
        this.putItem("neutron_reflector", Ic2Items.reactorReflector);
        this.putItem("thick_neutron_reflector", Ic2Items.reactorReflectorThick);
        this.putItem("iridium_neutron_reflector", Ic2Items.reactorReflectorIridium);
        this.putItem("rsh_condensator", Ic2Items.reactorCondensator);
        this.putItem("lzh_condensator", Ic2Items.reactorCondensatorLap);
        this.putItem("redstoneUranium_fuel_rod", Ic2Items.reactorUraniumRodSingle);
        this.putItem("dual_redstoneUranium_fuel_rod", Ic2Items.reactorUraniumRodDual);
        this.putItem("quad_redstoneUranium_fuel_rod", Ic2Items.reactorUraniumRodQuad);
        this.putItem("blazeUranium_fuel_rod", Ic2Items.reactorUraniumRodSingle);
        this.putItem("dual_blazeUranium_fuel_rod", Ic2Items.reactorUraniumRodDual);
        this.putItem("quad_blazeUranium_fuel_rod", Ic2Items.reactorUraniumRodQuad);
        this.putItem("enderUranium_fuel_rod", Ic2Items.reactorUraniumRodSingle);
        this.putItem("dual_enderUranium_fuel_rod", Ic2Items.reactorUraniumRodDual);
        this.putItem("quad_enderUranium_fuel_rod", Ic2Items.reactorUraniumRodQuad);
        this.putItem("netherStarUranium_fuel_rod", Ic2Items.reactorUraniumRodSingle);
        this.putItem("dual_netherStarUranium_fuel_rod", Ic2Items.reactorUraniumRodDual);
        this.putItem("quad_netherStarUranium_fuel_rod", Ic2Items.reactorUraniumRodQuad);
        this.putItem("charcoalUranium_fuel_rod", Ic2Items.reactorUraniumRodSingle);
        this.putItem("dual_charcoalUranium_fuel_rod", Ic2Items.reactorUraniumRodDual);
        this.putItem("quad_charcoalUranium_fuel_rod", Ic2Items.reactorUraniumRodQuad);
        this.putItem("mox_fuel_rod", this.getNoUse());
        this.putItem("dual_mox_fuel_rod", this.getNoUse());
        this.putItem("quad_mox_fuel_rod", this.getNoUse());
        this.putItem("lithium_fuel_rod", this.getNoUse());
        this.putItem("tfbp", Ic2Items.tfbp);
        this.putItem("tfbp", "blank", Ic2Items.tfbp);
        this.putItem("tfbp", "chilling", Ic2Items.tfbpChilling);
        this.putItem("tfbp", "cultivation", Ic2Items.tfbpCultivation);
        this.putItem("tfbp", "desertification", Ic2Items.tfbpDesertification);
        this.putItem("tfbp", "flatification", Ic2Items.tfbpFlatificator);
        this.putItem("tfbp", "irrigation", Ic2Items.tfbpIrrigation);
        this.putItem("tfbp", "mushroom", Ic2Items.tfbpMushroom);
        this.putItem("tfbp", "biome_blank", Ic2Items.tfbpBiome);
        this.putItem("tfbp", "biome_chilling", Ic2Items.tfbpBiomeChilling);
        this.putItem("tfbp", "biome_cultivation", Ic2Items.tfbpBiomeCultivation);
        this.putItem("tfbp", "biome_desertification", Ic2Items.tfbpBiomeDesertification);
        this.putItem("tfbp", "biome_undergrowth", Ic2Items.tfbpBiomeUndergrowth);
        this.putItem("tfbp", "biome_irrigation", Ic2Items.tfbpBiomeIrrigation);
        this.putItem("tfbp", "biome_mushroom", Ic2Items.tfbpBiomeMushroom);
        this.putItem("bronze_axe", Ic2Items.bronzeAxe);
        this.putItem("bronze_hoe", Ic2Items.bronzeHoe);
        this.putItem("bronze_pickaxe", Ic2Items.bronzePickaxe);
        this.putItem("bronze_shovel", Ic2Items.bronzeShovel);
        this.putItem("bronze_sword", Ic2Items.bronzeSword);
        this.putItem("containment_box", this.getNoUse());
        this.putItem("cutter", Ic2Items.cutter);
        this.putItem("debug_item", Ic2Items.debugItem);
        this.putItem("foam_sprayer", Ic2Items.cfSprayer);
        this.putItem("foam_sprayer_electric", Ic2Items.electricCfSprayer);
        this.putItem("forge_hammer", this.getNoUse());
        this.putItem("frequency_transmitter", Ic2Items.frequencyTransmitter);
        this.putItem("meter", Ic2Items.euReader);
        this.putItem("tool_box", Ic2Items.toolBox);
        this.putItem("carbon_box", Ic2Items.carbonBox);
        this.putItem("iridium_box", Ic2Items.iridiumBox);
        this.putItem("treetap", Ic2Items.treeTap);
        this.putItem("wrench", Ic2Items.wrench);
        this.putItem("booze_mug", Ic2Items.mugBooze);
        this.putItem("mug", Ic2Items.emptyMug);
        this.putItem("mug", "empty", Ic2Items.emptyMug);
        this.putItem("mug", "cold_coffee", Ic2Items.coldCoffee);
        this.putItem("mug", "dark_coffee", Ic2Items.darkCoffee);
        this.putItem("mug", "coffee", Ic2Items.coffee);
        this.putItem("mug", "cold_tea", Ic2Items.coldTea);
        this.putItem("mug", "dark_tea", Ic2Items.blackTea);
        this.putItem("mug", "tea", Ic2Items.tea);
        this.putItem("mug", "ice_tea", Ic2Items.iceTea);
        this.putItem("cropnalyzer", Ic2Items.cropAnalyzer);
        this.putItem("weeding_trowel", this.getNoUse());
        this.putItem("scanner", Ic2Items.scanner);
        this.putItem("advanced_scanner", Ic2Items.advScanner);
        this.putItem("ranged_scanner", Ic2Items.rangedODScanner);
        this.putItem("advanced_ranged_scanner", Ic2Items.rangedOVScanner);
        this.putItem("bigRanged_scanner", Ic2Items.bigRangedODScanner);
        this.putItem("advanced_bigRanged_scanner", Ic2Items.bigRangedOVScanner);
        this.putItem("low_oreValue_scanner", Ic2Items.lowOVDScanner);
        this.putItem("med_oreValue_scanner", Ic2Items.medOVDScanner);
        this.putItem("big_oreValue_scanner", Ic2Items.bigOVDScanner);
        this.putItem("setted_oreValue_scanner", Ic2Items.settedOVDScanner);
        this.putItem("quarry_scanner", Ic2Items.quarryScanner);
        this.putItem("chainsaw", Ic2Items.chainSaw);
        this.putItem("drill", Ic2Items.electricDrill);
        this.putItem("diamond_drill", Ic2Items.diamondDrill);
        this.putItem("electric_hoe", Ic2Items.electricHoe);
        this.putItem("electric_treetap", Ic2Items.electricTreeTap);
        this.putItem("electric_wrench", Ic2Items.electricWrench);
        this.putItem("iridium_drill", this.getNoUse());
        this.putItem("mining_laser", Ic2Items.miningLaser);
        this.putItem("nano_saber", Ic2Items.nanoSaber);
        this.putItem("obscurator", Ic2Items.obscurator);
        this.putItem("wind_meter", this.getNoUse());
        this.putItem("painter", Ic2Items.painter);
        this.putItem("painter", "black", Ic2Items.blackPainter);
        this.putItem("painter", "blue", Ic2Items.bluePainter);
        this.putItem("painter", "brown", Ic2Items.brownPainter);
        this.putItem("painter", "cyan", Ic2Items.cyanPainter);
        this.putItem("painter", "gray", Ic2Items.darkGreyPainter);
        this.putItem("painter", "green", Ic2Items.greenPainter);
        this.putItem("painter", "light_blue", Ic2Items.cloudPainter);
        this.putItem("painter", "light_gray", Ic2Items.lightGreyPainter);
        this.putItem("painter", "lime", Ic2Items.limePainter);
        this.putItem("painter", "magenta", Ic2Items.magentaPainter);
        this.putItem("painter", "orange", Ic2Items.orangePainter);
        this.putItem("painter", "pink", Ic2Items.pinkPainter);
        this.putItem("painter", "purple", Ic2Items.purplePainter);
        this.putItem("painter", "red", Ic2Items.redPainter);
        this.putItem("painter", "white", Ic2Items.whitePainter);
        this.putItem("painter", "yellow", Ic2Items.yellowPainter);
        this.putItem("cell", Ic2Items.emptyCell);
        this.putItem("cell", "empty", Ic2Items.emptyCell);
        this.putItem("cell", "water", Ic2Items.waterCell);
        this.putItem("cell", "lava", Ic2Items.lavaCell);
        this.putItem("cell", "air", Ic2Items.airCell);
        this.putItem("cell", "coal_fuel", Ic2Items.coalFuelCell);
        this.putItem("cell", "hydrated_coal_fuel", Ic2Items.hydratedCoalCell);
        this.putItem("cell", "bio", Ic2Items.bioCell);
        this.putItem("cell", "bio_fuel", Ic2Items.bioFuelCell);
        this.putItem("cell", "electrolyzed", Ic2Items.electrolyzedWaterCell);
        this.putItem("cell", "hydration", Ic2Items.hydrationCell);
        this.putList("fluid_cell", Arrays.asList("ic2air", "ic2biogas", "ic2biomass", "ic2construction_foam", "ic2coolant", "ic2distilled_water", "ic2heavy_water", "ic2hot_coolant", "ic2hot_water", "ic2hydrogen", "ic2oxygen", "ic2pahoehoe_lava", "ic2steam", "ic2superheated_steam", "ic2uu_matter", "ic2weed_ex", "lava", "water"), this.getNoUse());
        this.putItem("upgrade", Ic2Items.overClockerUpgrade);
        this.putItem("upgrade", "overclocker", Ic2Items.overClockerUpgrade);
        this.putItem("upgrade", "transformer", Ic2Items.transformerUpgrade);
        this.putItem("upgrade", "energy_storage", Ic2Items.energyStorageUpgrade);
        this.putItem("upgrade", "redstone_inverter", Ic2Items.redstoneIUpgrade);
        this.putItem("upgrade", "ejector", this.getNoUse());
        this.putItem("upgrade", "pulling", this.getNoUse());
        this.putItem("upgrade", "fluid_ejector", this.getNoUse());
        this.putItem("upgrade", "energy_multiplier", Ic2Items.energyMultiplierUpgrade);
        this.putItem("upgrade", "redstone_sensitivty", Ic2Items.redstoneSUpgrade);
        this.putItem("upgrade", "import_basic", Ic2Items.importBasicUpgrade);
        this.putItem("upgrade", "import", Ic2Items.importUpgrade);
        this.putItem("upgrade", "export_basic", Ic2Items.exportBasicUpgrade);
        this.putItem("upgrade", "export", Ic2Items.exportUpgrade);
        this.putItem("upgrade", "muffler", Ic2Items.mufflerUpgrade);
        this.putItem("upgrade", "mute", Ic2Items.muteUpgrade);
        this.putItem("upgrade", "exp", Ic2Items.expCollectorUpgrade);
        this.putItem("upgrade", "efficency", Ic2Items.efficencyUpgrade);
        this.putItem("upgrade", "loudness", Ic2Items.loudnessUpgrade);
        this.putItem("upgrade", "creative", Ic2Items.creativeUpgrade);
        this.putItem("upgrade", "export_RoundRobin", Ic2Items.roundRobinExport);
        this.putItem("upgrade", "slowdown", Ic2Items.slowdownUpgrade);
        this.putItem("upgrade", "filtered_import_basic", Ic2Items.filteredImportBasicUpgrade);
        this.putItem("upgrade", "filtered_import", Ic2Items.filteredImportUpgrade);
        this.putItem("upgrade", "filtered_export_basic", Ic2Items.filteredExportBasicUpgrade);
        this.putItem("upgrade", "filtered_export", Ic2Items.filteredExportBasicUpgrade);
        this.putItem("upgrade", "fluid_import_basic", Ic2Items.basicFluidImportUpgrade);
        this.putItem("upgrade", "fluid_import", Ic2Items.fluidImportUpgrade);
        this.putItem("upgrade", "fluid_filtered_import_basic", Ic2Items.filteredBasicFluidImportUpgrade);
        this.putItem("upgrade", "fluid_filtered_import", Ic2Items.filteredFluidImportUpgrade);
        this.putItem("upgrade", "fluid_export_basic", Ic2Items.basicFluidExportUpgrade);
        this.putItem("upgrade", "fluid_export", Ic2Items.fluidExportUpgrade);
        this.putItem("upgrade", "fluid_filtered_export_basic", Ic2Items.filteredBasicFluidExportUpgrade);
        this.putItem("upgrade", "fluid_filtered_export", Ic2Items.filteredFluidExportUpgrade);
        this.putItem("upgrade", "reactor_track", Ic2Items.reactorTrackUpgrade);
        this.putItem("upgrade", "cobble_gen", Ic2Items.cobbleGenUpgrade);
        this.putItem("upgrade", "crafting", Ic2Items.craftingUpgrade);
        this.putItem("upgrade", "quantum_overclocker", Ic2Items.quantumOverclockerUpgrade);
        this.putItem("upgrade", "sawblade_efficient", Ic2Items.efficientSawBladeUpgrade);
        this.putItem("upgrade", "sawblade_durable", Ic2Items.durabileSawBladeUpgrade);
        this.putItem("upgrade", "creative", Ic2Items.creativeUpgrade);
        this.putItem("padupgrade", Ic2Items.crystalUpgradeKid);
        this.putItem("padupgrade", "kid_crystal", Ic2Items.crystalUpgradeKid);
        this.putItem("padupgrade", "kid_lapotronic", Ic2Items.lapotronicUpgradeKid);
        this.putItem("padupgrade", "kid_fission", Ic2Items.fissionUpgradeKid);
        this.putItem("padupgrade", "damage", Ic2Items.padUpgradeDamage);
        this.putItem("padupgrade", "drain", Ic2Items.padUpgradeDrain);
        this.putItem("padupgrade", "proximity", Ic2Items.padUpgradeProximity);
        this.putItem("padupgrade", "wide", Ic2Items.padUpgradeWideBand);
        this.putItem("padupgrade", "armor", Ic2Items.padUpgradeArmorPriorty);
        this.putItem("padupgrade", "field_basic", Ic2Items.padUpgradeBasicFieldUpgrade);
        this.putItem("padupgrade", "field_normal", Ic2Items.padUpgradeFieldUpgrade);
        this.putItem("padupgrade", "field_advanced", Ic2Items.padUpgradeAdvFieldUpgrade);
        this.putItem("invUpgrade", Ic2Items.automationUpgrade);
        this.putItem("invUpgrade", "automation", Ic2Items.automationUpgrade);
        this.putItem("invUpgrade", "sideAccess", Ic2Items.sideAccessUpgrade);
        this.putItem("invUpgrade", "rotation", Ic2Items.rotationDissablerUpgrade);
        this.putItem("invUpgrade", "slotType", Ic2Items.slotTypeModifierUpgrade);
        this.putItem("invUpgrade", "slotAccess", Ic2Items.slotAccessModifierUpgrade);
        this.putItem("invUpgrade", "slotSideAccess", Ic2Items.slotSideUpgrade);
        this.putItem("energy_pack", Ic2Items.batPack);
        this.putItem("lappack", Ic2Items.lapPack);
        this.putItem("advanced_batpack", this.getNoUse());
        this.putItem("alloy_chestplate", Ic2Items.compositeChest);
        this.putItem("alloy_boots", Ic2Items.compositeBoots);
        this.putItem("alloy_leggings", Ic2Items.compositeLeggings);
        this.putItem("alloy_helmet", Ic2Items.compositeHelmet);
        this.putItem("bronze_chestplate", Ic2Items.bronzeChest);
        this.putItem("bronze_boots", Ic2Items.bronzeBoots);
        this.putItem("bronze_leggings", Ic2Items.bronzeLeggings);
        this.putItem("bronze_helmet", Ic2Items.bronzeHelmet);
        this.putItem("hazmat_chestplate", Ic2Items.hazmatChest);
        this.putItem("rubber_boots", Ic2Items.hazmatBoots);
        this.putItem("hazmat_leggings", Ic2Items.hazmatLeggings);
        this.putItem("hazmat_helmet", Ic2Items.hazmatHelmet);
        this.putItem("cf_pack", Ic2Items.cfPack);
        this.putItem("jetpack", Ic2Items.jetpack);
        this.putItem("jetpack_electric", Ic2Items.electricJetpack);
        this.putItem("jetpack_nuclear", Ic2Items.nuclearJetpack);
        this.putItem("jetpack_compact_electric", Ic2Items.compactedElectricJetpack);
        this.putItem("jetpack_compact_nuclear", Ic2Items.compactedNuclearJetpack);
        this.putItem("nano_chestplate", Ic2Items.nanoChest);
        this.putItem("nano_boots", Ic2Items.nanoBoots);
        this.putItem("nano_leggings", Ic2Items.nanoLeggings);
        this.putItem("nano_helmet", Ic2Items.nanoHelmet);
        this.putItem("quantum_chestplate", Ic2Items.quantumChest);
        this.putItem("quantum_boots", Ic2Items.quantumBoots);
        this.putItem("quantum_leggings", Ic2Items.quantumLeggings);
        this.putItem("quantum_helmet", Ic2Items.quantumHelmet);
        this.putItem("quantum_jetpack", Ic2Items.quantumJetplate);
        this.putItem("nightvision_goggles", Ic2Items.nightVisionGoggles);
        this.putItem("solar_helmet", Ic2Items.solarHelmet);
        this.putItem("adv_solar_helmet", Ic2Items.advSolarHelmet);
        this.putItem("static_boots", Ic2Items.staticBoots);
        this.putItem("filled_tin_can", Ic2Items.filledTinCan);
        this.putItem("rotor_wood", this.getNoUse());
        this.putItem("rotor_iron", this.getNoUse());
        this.putItem("rotor_carbon", this.getNoUse());
        this.putItem("rotor_steel", this.getNoUse());
        this.putItem("coin", Ic2Items.industrialCoin);
        this.putItem("coin", "normal", Ic2Items.industrialCoin);
        this.putBlock("te", Ic2States.machine, Ic2Items.machine);
        this.putBlock("te", "itnt", Ic2States.industrialTNT, Ic2Items.industrialTNT);
        this.putBlock("te", "nuke", Ic2States.nuke, Ic2Items.nuke);
        this.putBlock("te", "generator", Ic2States.generator, Ic2Items.generator);
        this.putBlock("te", "geo_generator", Ic2States.geothermalGenerator, Ic2Items.geothermalGenerator);
        this.putBlock("te", "kinetic_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "rt_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "semifluid_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "solar_generator", Ic2States.solarPanel, Ic2Items.solarPanel);
        this.putBlock("te", "solar_generator_lv", Ic2States.lvSolarPanel, Ic2Items.lvSolarPanel);
        this.putBlock("te", "solar_generator_mv", Ic2States.mvSolarPanel, Ic2Items.mvSolarPanel);
        this.putBlock("te", "solar_generator_hv", Ic2States.hvSolarPanel, Ic2Items.hvSolarPanel);
        this.putBlock("te", "water_generator", Ic2States.waterMill, Ic2Items.waterMill);
        this.putBlock("te", "water_generator_lv", Ic2States.lvWaterMill, Ic2Items.lvWaterMill);
        this.putBlock("te", "water_generator_mv", Ic2States.mvWaterMill, Ic2Items.mvWaterMill);
        this.putBlock("te", "water_generator_hv", Ic2States.hvWaterMill, Ic2Items.hvWaterMill);
        this.putBlock("te", "basic_steam_turbine", Ic2States.basicTurbine, Ic2Items.basicTurbine);
        this.putBlock("te", "electric_heat_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "fluid_heat_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "rt_heat_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "solid_heat_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "electric_kinetic_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "manual_kinetic_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "steam_kinetic_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "stirling_kinetic_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "water_kinetic_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "wind_kinetic_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "nuclear_reactor", Ic2States.nuclearReactor, Ic2Items.nuclearReactor);
        this.putBlock("te", "steam_reactor", Ic2States.steamReactor, Ic2Items.steamReactor);
        this.putBlock("te", "reactor_access_hatch", this.getAir(), this.getNoUse());
        this.putBlock("te", "reactor_chamber", Ic2States.reactorChamber, Ic2Items.reactorChamber);
        this.putBlock("te", "steam_reactor_chamber", Ic2States.steamReactorChamber, Ic2Items.steamReactorChamber);
        this.putBlock("te", "reactor_fluid_port", this.getAir(), this.getNoUse());
        this.putBlock("te", "reactor_redstone_port", this.getAir(), this.getNoUse());
        this.putBlock("te", "condenser", this.getAir(), this.getNoUse());
        this.putBlock("te", "fluid_bottler", this.getAir(), this.getNoUse());
        this.putBlock("te", "fluid_distributor", this.getAir(), this.getNoUse());
        this.putBlock("te", "fluid_regulator", this.getAir(), this.getNoUse());
        this.putBlock("te", "liquid_heat_exchanger", this.getAir(), this.getNoUse());
        this.putBlock("te", "pump", Ic2States.pump, Ic2Items.pump);
        this.putBlock("te", "solar_distiller", this.getAir(), this.getNoUse());
        this.putBlock("te", "steam_generator", this.getAir(), this.getNoUse());
        this.putBlock("te", "item_buffer", this.getAir(), this.getNoUse());
        this.putBlock("te", "luminator_flat", Ic2States.luminator, Ic2Items.luminator);
        this.putBlock("te", "luminator_multipart", Ic2States.luminatorMultipart, Ic2Items.luminatorMultipart);
        this.putBlock("te", "magnetizer", Ic2States.magnetizer, Ic2Items.magnetizer);
        this.putBlock("te", "teleporter", Ic2States.teleporter, Ic2Items.teleporter);
        this.putBlock("te", "terraformer", Ic2States.terraformer, Ic2Items.terraformer);
        this.putBlock("te", "tesla_coil", Ic2States.teslaCoil, Ic2Items.teslaCoil);
        this.putBlock("te", "canner", Ic2States.canner, Ic2Items.canner);
        this.putBlock("te", "compressor", Ic2States.compressor, Ic2Items.compressor);
        this.putBlock("te", "electric_furnace", Ic2States.electroFurnace, Ic2Items.electroFurnace);
        this.putBlock("te", "extractor", Ic2States.extractor, Ic2Items.extractor);
        this.putBlock("te", "iron_furnace", Ic2States.ironFurnace, Ic2Items.ironFurnace);
        this.putBlock("te", "macerator", Ic2States.macerator, Ic2Items.macerator);
        this.putBlock("te", "recycler", Ic2States.recycler, Ic2Items.recycler);
        this.putBlock("te", "solid_canner", this.getAir(), this.getNoUse());
        this.putBlock("te", "blast_furnace", this.getAir(), this.getNoUse());
        this.putBlock("te", "block_cutter", this.getAir(), this.getNoUse());
        this.putBlock("te", "centrifuge", this.getAir(), this.getNoUse());
        this.putBlock("te", "fermenter", this.getAir(), this.getNoUse());
        this.putBlock("te", "induction_furnace", Ic2States.inductionFurnace, Ic2Items.inductionFurnace);
        this.putBlock("te", "metal_former", this.getAir(), this.getNoUse());
        this.putBlock("te", "ore_washing_plant", this.getAir(), this.getNoUse());
        this.putBlock("te", "advanced_miner", this.getAir(), this.getNoUse());
        this.putBlock("te", "crop_harvester", Ic2States.cropHarvester, Ic2Items.cropHarvester);
        this.putBlock("te", "cropmatron", Ic2States.cropmatron, Ic2Items.cropmatron);
        this.putBlock("te", "miner", Ic2States.miner, Ic2Items.miner);
        this.putBlock("te", "matter_generator", Ic2States.massfabricator, Ic2Items.massfabricator);
        this.putBlock("te", "pattern_storage", this.getAir(), this.getNoUse());
        this.putBlock("te", "replicator", this.getAir(), this.getNoUse());
        this.putBlock("te", "scanner", this.getAir(), this.getNoUse());
        this.putBlock("te", "trade_o_mat", Ic2States.tradeOMat, Ic2Items.tradeOMat);
        this.putBlock("te", "fluid_o_mat", Ic2States.fluidOMat, Ic2Items.fluidOMat);
        this.putBlock("te", "energy_o_mat", Ic2States.energyOMat, Ic2Items.energyOMat);
        this.putBlock("te", "personal_chest", Ic2States.personalSafe, Ic2Items.personalSafe);
        this.putBlock("te", "personal_tank", Ic2States.personalTank, Ic2Items.personalTank);
        this.putBlock("te", "personal_energystorage", Ic2States.personalEnergyStorage, Ic2Items.personalEnergyStorage);
        this.putBlock("te", "personal_batbox", Ic2States.personalEnergyStorage, Ic2Items.personalEnergyStorageBatBox);
        this.putBlock("te", "personal_mfe", Ic2States.personalEnergyStorage, Ic2Items.personalEnergyStorageMFE);
        this.putBlock("te", "personal_mfsu", Ic2States.personalEnergyStorage, Ic2Items.personalEnergyStorageMFSU);
        this.putBlock("te", "chargepad_batbox", this.getAir(), this.getNoUse());
        this.putBlock("te", "chargepad_cesu", this.getAir(), this.getNoUse());
        this.putBlock("te", "chargepad_mfe", this.getAir(), this.getNoUse());
        this.putBlock("te", "chargepad_mfsu", this.getAir(), this.getNoUse());
        this.putBlock("te", "chargepad_mfsu", this.getAir(), this.getNoUse());
        this.putBlock("te", "batbox", Ic2States.batBox, Ic2Items.batBox);
        this.putBlock("te", "cesu", this.getAir(), this.getNoUse());
        this.putBlock("te", "mfe", Ic2States.mfe, Ic2Items.mfe);
        this.putBlock("te", "mfsu", Ic2States.mfsu, Ic2Items.mfsu);
        this.putBlock("te", "batteryStation", Ic2States.batteryStation, Ic2Items.batteryStation);
        this.putBlock("te", "creativeStorage", Ic2States.creativeEnergyStorage, Ic2Items.creativeEnergyStorage);
        this.putBlock("te", "electrolyzer", Ic2States.electrolyzer, Ic2Items.electrolyzer);
        this.putBlock("te", "lv_transformer", Ic2States.transformerLV, Ic2Items.transformerLV);
        this.putBlock("te", "mv_transformer", Ic2States.transformerMV, Ic2Items.transformerMV);
        this.putBlock("te", "hv_transformer", Ic2States.transformerHV, Ic2Items.transformerHV);
        this.putBlock("te", "ev_transformer", Ic2States.transformerEV, Ic2Items.transformerEV);
        this.putBlock("te", "adjustable_transformer", Ic2States.adjustableTransformer, Ic2Items.adjustableTransformer);
        this.putBlock("te", "sound_beacon", Ic2States.soundBeacon, Ic2Items.soundBeacon);
        this.putBlock("te", "crop_scanner", Ic2States.cropAnaylzer, Ic2Items.cropAnalyzerBlock);
        this.putBlock("te", "tank", this.getAir(), this.getNoUse());
        this.putBlock("te", "chunk_loader", this.getAir(), this.getNoUse());
        this.putBlock("te", "macerator_rotary", Ic2States.rotaryMacerator, Ic2Items.rotaryMacerator);
        this.putBlock("te", "extractor_centrifugal", Ic2States.centrifugalExtractor, Ic2Items.centrifugalExtractor);
        this.putBlock("te", "compressor_singularity", Ic2States.singularityCompressor, Ic2Items.singularityCompressor);
        this.putBlock("te", "canner_vacuum", Ic2States.vacuumCanner, Ic2Items.vacuumCanner);
        this.putBlock("te", "recycler_compacting", Ic2States.compactingRecycler, Ic2Items.compactingRecycler);
        this.putBlock("te", "electrolyzer_charged", Ic2States.chargedElectrolyzer, Ic2Items.chargedElectrolyzer);
        this.putBlock("te", "ore_scanner", Ic2States.oreScannerBlock, Ic2Items.oreScannerBlock);
        this.putBlock("te", "reactor_planner", Ic2States.reactorPlanner, Ic2Items.reactorPlanner);
        this.putBlock("te", "uranium_enricher", Ic2States.uraniumEnricher, Ic2Items.uraniumEnricher);
        this.putBlock("te", "enchanter_electric", Ic2States.electricEnchanter, Ic2Items.electricEnchanter);
        this.putBlock("te", "chargepad_lv", Ic2States.chargePadLV, Ic2Items.chargePadLV);
        this.putBlock("te", "chargepad_mv", Ic2States.chargePadMV, Ic2Items.chargePadMV);
        this.putBlock("te", "chargepad_hv", Ic2States.chargePadHV, Ic2Items.chargePadHV);
        this.putBlock("te", "chargepad_nuclear", Ic2States.chargePadNuclear, Ic2Items.chargePadNuclear);
        this.putBlock("cable", Ic2States.copperCable, Ic2Items.copperCable);
        this.putBlock("cable", "type:tin", Ic2States.tinCable, Ic2Items.tinCable);
        this.putBlock("cable", "type:copper", Ic2States.copperCable, Ic2Items.copperCable);
        this.putBlock("cable", "type:gold", Ic2States.goldCable, Ic2Items.goldCable);
        this.putBlock("cable", "type:iron", Ic2States.ironCable, Ic2Items.ironCable);
        this.putBlock("cable", "type:glass", Ic2States.glassFiberCable, Ic2Items.glassFiberCable);
        this.putBlock("cable", "type:splitter", Ic2States.splitterCable, Ic2Items.splitterCable);
        this.putBlock("cable", "type:detector", Ic2States.detectorCable, Ic2Items.detectorCable);
        this.putBlock("cable", "type:bronze", Ic2States.bronzeCable, Ic2Items.bronzeCable);
        this.putBlock("cable", "type:plasma", Ic2States.plasmaCable, Ic2Items.plasmaCable);
        this.putModularBlock("cable", new String[]{"type:tin", "insulation:0"}, Ic2States.tinCable, Ic2Items.tinCable);
        this.putModularBlock("cable", new String[]{"type:tin", "insulation:1"}, Ic2States.tinCable, Ic2Items.tinCable);
        this.putModularBlock("cable", new String[]{"type:copper", "insulation:0"}, Ic2States.copperCable, Ic2Items.copperCable);
        this.putModularBlock("cable", new String[]{"type:copper", "insulation:1"}, Ic2States.copperCable, Ic2Items.insulatedCopperCable);
        this.putModularBlock("cable", new String[]{"type:gold", "insulation:0"}, Ic2States.goldCable, Ic2Items.goldCable);
        this.putModularBlock("cable", new String[]{"type:gold", "insulation:1"}, Ic2States.goldCable, Ic2Items.insulatedGoldCable);
        this.putModularBlock("cable", new String[]{"type:gold", "insulation:2"}, Ic2States.goldCable, Ic2Items.doubleInsulatedGoldCable);
        this.putModularBlock("cable", new String[]{"type:iron", "insulation:0"}, Ic2States.ironCable, Ic2Items.ironCable);
        this.putModularBlock("cable", new String[]{"type:iron", "insulation:1"}, Ic2States.ironCable, Ic2Items.insulatedIronCable);
        this.putModularBlock("cable", new String[]{"type:iron", "insulation:2"}, Ic2States.ironCable, Ic2Items.doubleInsulatedIronCable);
        this.putModularBlock("cable", new String[]{"type:iron", "insulation:3"}, Ic2States.ironCable, Ic2Items.tribbleInsulatedIronCable);
        this.putModularBlock("cable", new String[]{"type:glass", "insulation:0"}, Ic2States.glassFiberCable, Ic2Items.glassFiberCable);
        this.putModularBlock("cable", new String[]{"type:splitter", "insulation:0"}, Ic2States.splitterCable, Ic2Items.splitterCable);
        this.putModularBlock("cable", new String[]{"type:detector", "insulation:0"}, Ic2States.detectorCable, Ic2Items.detectorCable);
        this.putModularBlock("cable", new String[]{"type:bronze", "insulation:0"}, Ic2States.bronzeCable, Ic2Items.bronzeCable);
        this.putModularBlock("cable", new String[]{"type:bronze", "insulation:1"}, Ic2States.bronzeCable, Ic2Items.insulatedBronzeCable);
        this.putModularBlock("cable", new String[]{"type:bronze", "insulation:2"}, Ic2States.bronzeCable, Ic2Items.doubleInsulatedBronzeCable);
        this.putBlock("dynamite", Ic2States.dynamite, Ic2Items.dynamite);
        this.putBlock("dynamite", "normal", Ic2States.dynamite, Ic2Items.dynamite);
        this.putBlock("dynamite", "remote", Ic2States.dynamite, Ic2Items.dynamiteRemote);
        this.putBlock("resource", Ic2States.copperOre, Ic2Items.copperOre);
        this.putBlock("resource", "basalt", this.getAir(), this.getNoUse());
        this.putBlock("resource", "copper_ore", Ic2States.copperOre, Ic2Items.copperOre);
        this.putBlock("resource", "lead_ore", this.getAir(), this.getNoUse());
        this.putBlock("resource", "tin_ore", Ic2States.tinOre, Ic2Items.tinOre);
        this.putBlock("resource", "uranium_ore", Ic2States.uraniumOre, Ic2Items.uraniumOre);
        this.putBlock("resource", "silver_ore", Ic2States.silverOre, Ic2Items.silverOre);
        this.putBlock("resource", "bronze_block", Ic2States.bronzeBlock, Ic2Items.bronzeBlock);
        this.putBlock("resource", "copper_block", Ic2States.copperBlock, Ic2Items.copperBlock);
        this.putBlock("resource", "lead_block", this.getAir(), this.getNoUse());
        this.putBlock("resource", "steel_block", this.getAir(), this.getNoUse());
        this.putBlock("resource", "tin_block", Ic2States.tinBlock, Ic2Items.tinBlock);
        this.putBlock("resource", "silver_block", Ic2States.silverBlock, Ic2Items.silverBlock);
        this.putBlock("resource", "uranium_block", Ic2States.uraniumBlock, Ic2Items.uraniumBlock);
        this.putBlock("resource", "reinforced_stone", Ic2States.reinforcedStone, Ic2Items.reinforcedStone);
        this.putBlock("resource", "machine", Ic2States.machine, Ic2Items.machine);
        this.putBlock("resource", "advanced_machine", Ic2States.advMachine, Ic2Items.advMachine);
        this.putBlock("resource", "reactor_vessel", this.getAir(), this.getNoUse());
        this.putBlock("leaves", Ic2States.rubberLeaves, Ic2Items.rubberLeaves);
        this.putBlock("rubber_wood", Ic2States.rubberWood, Ic2Items.rubberWood);
        this.putBlock("sapling", Ic2States.rubberSapling, Ic2Items.rubberSapling);
        this.putBlock("crop", Ic2States.cropStick, Ic2Items.cropStick);
        this.putBlock("barrel", Ic2States.barrel, Ic2Items.barrel);
        this.putBlock("scaffold", Ic2States.woodenScaffold, Ic2Items.woodenScaffold);
        this.putBlock("scaffold", "wood", Ic2States.woodenScaffold, Ic2Items.woodenScaffold);
        this.putBlock("scaffold", "reinforced_wood", Ic2States.woodenScaffold, Ic2Items.woodenScaffold);
        this.putBlock("scaffold", "iron", Ic2States.ironScaffold, Ic2Items.ironScaffold);
        this.putBlock("scaffold", "reinforced_iron", Ic2States.ironScaffold, Ic2Items.ironScaffold);
        this.putBlock("foam", Ic2States.constructionFoam, Ic2Items.constructionFoam);
        this.putBlock("foam", "normal", Ic2States.constructionFoam, Ic2Items.constructionFoam);
        this.putBlock("foam", "reinforced", this.getAir(), this.getNoUse());
        this.putBlock("fence", Ic2States.ironFence, Ic2Items.ironFence);
        this.putBlock("sheet", Ic2States.rubberSheet, Ic2Items.rubberSheet);
        this.putBlock("sheet", "rubber", Ic2States.rubberSheet, Ic2Items.rubberSheet);
        this.putBlock("sheet", "resin", Ic2States.resinSheet, Ic2Items.stickyResin);
        this.putBlock("glass", Ic2States.reinforcedGlass, Ic2Items.reinforcedGlass);
        this.putBlock("glass", "reinforced", Ic2States.reinforcedGlass, Ic2Items.reinforcedGlass);
        this.putBlock("wall", Ic2States.constructionFoam, Ic2Items.constructionFoam);
        this.putBlock("wall", "black", Ic2States.cfWallBlack, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "blue", Ic2States.cfWallBlue, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "brown", Ic2States.cfWallBrown, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "cyan", Ic2States.cfWallCyan, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "gray", Ic2States.cfWallGray, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "green", Ic2States.cfWallGreen, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "light_blue", Ic2States.cfWallLightBlue, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "light_gray", Ic2States.cfWallSilver, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "lime", Ic2States.cfWallLime, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "magenta", Ic2States.cfWallMagenta, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "orange", Ic2States.cfWallOrange, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "pink", Ic2States.cfWallPink, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "purple", Ic2States.cfWallPurple, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "red", Ic2States.cfWallRed, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "white", Ic2States.cfWallWhite, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "yellow", Ic2States.cfWallYellow, Ic2Items.constructionFoamWall);
        this.putBlock("wall", "textured", Ic2States.texturedWall, Ic2Items.constructionFoamWall);
        this.putBlock("mining_Pipe", Ic2States.miningPipe, Ic2Items.miningPipe);
        this.putBlock("mining_Pipe", "pipe", Ic2States.miningPipe, Ic2Items.miningPipe);
        this.putBlock("mining_Pipe", "tip", Ic2States.miningPipeTip, Ic2Items.miningPipeTip);
        this.putBlock("reinforced_door", Ic2States.reinforcedDoor, Ic2Items.reinforcedDoor);
    }

    private ItemStack getNoUse() {
        if (Ic2Items.noUse == null) {
            return ItemStack.field_190927_a;
        }
        return Ic2Items.noUse.func_77946_l();
    }

    private IBlockState getAir() {
        return Ic2States.noUse;
    }

    private void putItem(String key, String value, ItemStack stack) {
        this.stacks.put(new ResourceLocation(key, value), stack.func_77946_l());
    }

    private void putModularItem(String key, String[] value, ItemStack stack) {
        for (int x = 0; x < value.length; ++x) {
            for (int y = 0; y < value.length; ++y) {
                this.putItem(key, value[x] + "," + value[y], stack);
            }
        }
    }

    @Override
    public void putItem(String key, ItemStack stack) {
        this.items.put(key, stack.func_77946_l());
    }

    private void putList(String key, List<String> list, ItemStack stack) {
        this.putItem(key, stack);
        for (String value : list) {
            this.putItem(key, value, stack);
        }
    }

    @Override
    public void putStack(String name, String variant, ItemStack object) {
        this.stacks.put(new ResourceLocation(name, variant), object.func_77946_l());
    }

    private void putModularBlock(String key, String[] value, IBlockState state, ItemStack stack) {
        for (int x = 0; x < value.length; ++x) {
            for (int y = 0; y < value.length; ++y) {
                String data = value[x] + "," + value[y];
                this.putBlock(key, data, state, stack);
            }
        }
    }

    private void putBlock(String key, String value, IBlockState state, ItemStack stack) {
        ResourceLocation location = new ResourceLocation(key, value);
        this.stacks.put(location, stack.func_77946_l());
        this.states.put(location, state);
    }

    @Override
    public void putBlock(String key, IBlockState state, ItemStack stack) {
        this.items.put(key, stack.func_77946_l());
        this.blocks.put(key, state);
    }

    @Override
    public void putState(String name, String variant, IBlockState state, ItemStack stack) {
        ResourceLocation location = new ResourceLocation(name, variant);
        this.stacks.put(location, stack.func_77946_l());
        this.states.put(location, state);
    }

    @Override
    public List<String> getItemKeys() {
        return new ArrayList<String>(this.items.keySet());
    }

    @Override
    public List<String> getStackKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (ResourceLocation location : this.stacks.keySet()) {
            keys.add(location.toString());
        }
        return keys;
    }

    @Override
    public List<String> getBlockKeys() {
        return new ArrayList<String>(this.blocks.keySet());
    }

    @Override
    public List<String> getStateKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (ResourceLocation location : this.states.keySet()) {
            keys.add(location.toString());
        }
        return keys;
    }
}

