/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures.helpers;

import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureShaper {
    public static UnpackedBakedQuad genQuad(VertexFormat format, TRSRTransformation transform, float x1, float y1, float x2, float y2, float z, TextureAtlasSprite sprite, EnumFacing facing, int color) {
        float u1 = sprite.func_94214_a(0.0);
        float v1 = sprite.func_94207_b(0.0);
        float u2 = sprite.func_94214_a(16.0);
        float v2 = sprite.func_94207_b(16.0);
        float tmp = y1 /= 16.0f;
        y1 = 1.0f - (y2 /= 16.0f);
        y2 = 1.0f - tmp;
        return TextureShaper.putQuad(format, transform, facing, sprite, color, x1 /= 16.0f, y1, x2 /= 16.0f, y2, z, u1, v1, u2, v2);
    }

    private static UnpackedBakedQuad putQuad(VertexFormat format, TRSRTransformation transform, EnumFacing side, TextureAtlasSprite sprite, int color, float x1, float y1, float x2, float y2, float z, float u1, float v1, float u2, float v2) {
        side = side.func_176734_d();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(-1);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        if (side == EnumFacing.NORTH) {
            TextureShaper.putVertex(builder, format, transform, side, x1, y1, z, u1, v2, color);
            TextureShaper.putVertex(builder, format, transform, side, x2, y1, z, u2, v2, color);
            TextureShaper.putVertex(builder, format, transform, side, x2, y2, z, u2, v1, color);
            TextureShaper.putVertex(builder, format, transform, side, x1, y2, z, u1, v1, color);
        } else {
            TextureShaper.putVertex(builder, format, transform, side, x1, y1, z, u1, v2, color);
            TextureShaper.putVertex(builder, format, transform, side, x1, y2, z, u1, v1, color);
            TextureShaper.putVertex(builder, format, transform, side, x2, y2, z, u2, v1, color);
            TextureShaper.putVertex(builder, format, transform, side, x2, y1, z, u2, v2, color);
        }
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, TRSRTransformation transform, EnumFacing side, float x, float y, float z, float u, float v, int color) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    if (transform == TRSRTransformation.identity()) {
                        builder.put(e, new float[]{x, y, z, 1.0f});
                        continue block6;
                    }
                    vec.x = x;
                    vec.y = y;
                    vec.z = z;
                    vec.w = 1.0f;
                    transform.getMatrix().transform((Tuple4f)vec);
                    builder.put(e, new float[]{vec.x, vec.y, vec.z, vec.w});
                    continue block6;
                }
                case COLOR: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    builder.put(e, new float[]{r, g, b, a});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }
}

