/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiIntigration.core.machine.canner;

import ic2.api.classic.recipe.machine.ICannerRegistry;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.jeiIntigration.core.machine.canner.CannerRecipeWrapper;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class FuelCannerRecipeWrapper
extends CannerRecipeWrapper {
    ItemStack fuelCan = Ic2Items.fuelCan.func_77946_l();
    ItemStack filledFuelCan = Ic2Items.fullFuelCan.func_77946_l();
    ICannerRegistry.FuelInfo info;

    public FuelCannerRecipeWrapper(ICannerRegistry.FuelInfo data) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(this.filledFuelCan);
        nbt.func_74768_a("MaxFuel", 500);
        nbt.func_74768_a("Fuel", 500);
        this.info = data;
    }

    @Override
    public List<ItemStack> getInput() {
        return Arrays.asList(this.info.getItem().func_77946_l());
    }

    @Override
    public ItemStack getContainer() {
        return this.fuelCan;
    }

    @Override
    public ItemStack getOutput() {
        return this.filledFuelCan;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        if (this.info.getAmount() > 0) {
            String energy = Ic2InfoLang.fuelValue.getLocalizedFormatted(this.info.getAmount());
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(energy);
            fontRendererObj.func_78276_b(energy, recipeWidth - stringWidth + 35, 2, Color.gray.getRGB());
        }
        if (this.info.getMultiplier() != 0.0f) {
            int amount = (int)(this.info.getMultiplier() * 100.0f);
            String energy = Ic2InfoLang.fuelMultiplier.getLocalizedFormatted(amount + "%");
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(energy);
            fontRendererObj.func_78276_b(energy, recipeWidth - stringWidth + 45, 45, Color.gray.getRGB());
        }
    }
}

