/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.config.Filter;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.network.SyncRulesHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSyncRules
implements IMessage {
    private List<Pair<Filter, Settings>> rules;

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.rules = new ArrayList<Pair<Filter, Settings>>(size);
        for (int i = 0; i < size; ++i) {
            Filter filter = new Filter(buf);
            Settings settings = new Settings(buf);
            this.rules.add((Pair<Filter, Settings>)Pair.of((Object)filter, (Object)settings));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.rules.size());
        for (Pair<Filter, Settings> rule : this.rules) {
            Filter filter = (Filter)rule.getLeft();
            Settings settings = (Settings)rule.getRight();
            filter.toBytes(buf);
            settings.toBytes(buf);
        }
        Logging.log((String)("Rules packet size: " + buf.writerIndex() + " of " + buf.array().length));
    }

    public List<Pair<Filter, Settings>> getRules() {
        return this.rules;
    }

    public PacketSyncRules() {
    }

    public PacketSyncRules(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketSyncRules(List<Pair<Filter, Settings>> rules) {
        this.rules = rules;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> SyncRulesHelper.syncRulesFromServer(this));
        ctx.setPacketHandled(true);
    }
}

