/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.SideFilterData;
import buildcraft.additionalpipes.utils.InventoryUtils;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.lib.misc.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class PipeBehaviorJeweled
extends APPipe
implements IDebuggable {
    public SideFilterData[] filterData = new SideFilterData[6];

    public PipeBehaviorJeweled(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.init();
        NBTTagList filterList = nbt.func_150295_c("filterList", 10);
        for (int index = 0; index < this.filterData.length; ++index) {
            NBTTagCompound filterTag = filterList.func_150305_b(index);
            this.filterData[index].readFromNBT(filterTag);
        }
    }

    public PipeBehaviorJeweled(IPipe pipe) {
        super(pipe);
        this.init();
    }

    private void init() {
        for (int index = 0; index < this.filterData.length; ++index) {
            this.filterData[index] = new SideFilterData();
        }
    }

    public int getTextureIndex(EnumFacing connection) {
        if (connection == null) {
            return 0;
        }
        return connection.ordinal();
    }

    @PipeEventHandler
    public void onSideCheck(PipeEventItem.SideCheck event) {
        SideFilterData data;
        EnumSet<EnumFacing> disallowedSides = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            data = this.filterData[dir.ordinal()];
            if (data.matchesStack(event.stack)) continue;
            disallowedSides.add(dir);
        }
        if (disallowedSides.size() == 6) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                data = this.filterData[dir.ordinal()];
                if (!data.acceptsUnsortedItems()) continue;
                disallowedSides.remove(dir);
            }
        }
        event.disallowAll(disallowedSides);
    }

    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
            return super.onPipeActivate(player, trace, hitX, hitY, hitZ, part);
        }
        if (!player.field_70170_p.field_72995_K) {
            BlockPos pipePos = this.pipe.getHolder().getPipePos();
            player.openGui((Object)AdditionalPipes.instance, 6, this.pipe.getHolder().getPipeWorld(), pipePos.func_177958_n(), pipePos.func_177956_o(), pipePos.func_177952_p());
        }
        return true;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        NBTTagList filterList = new NBTTagList();
        for (int index = 0; index < this.filterData.length; ++index) {
            NBTTagCompound filterTag = new NBTTagCompound();
            this.filterData[index].writeToNBT(filterTag);
            filterList.func_74742_a((NBTBase)filterTag);
        }
        nbt.func_74782_a("filterList", (NBTBase)filterList);
        return nbt;
    }

    public void addDrops(NonNullList<ItemStack> toDrop, int fortune) {
        super.addDrops(toDrop, fortune);
        for (SideFilterData sideFilter : this.filterData) {
            toDrop.addAll(InventoryUtils.getItems((IItemHandler)sideFilter.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)));
        }
    }

    public void getDebugInfo(List<String> info, List<String> param2, EnumFacing side) {
        SideFilterData clickedSide = this.filterData[side.ordinal()];
        info.add("Accepts unsorted items: " + clickedSide.acceptsUnsortedItems());
        info.add("Matches NBT: " + clickedSide.matchNBT());
        info.add("Matches metadata: " + clickedSide.matchMetadata());
    }
}

