/*
 * Decompiled with CFR 0.152.
 */
package lib.item;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class ItemUtil {
    public static final Pattern pattern = Pattern.compile("((?<modid>.*?):)?(?<item>[^@]*)(@(?<damage>\\d+|[*])(x(?<size>\\d+))?)?");

    public static ItemStack getItemStack(String str) {
        Item item;
        int size;
        Matcher matcher = pattern.matcher(str);
        if (!matcher.find()) {
            return ItemStack.field_190927_a;
        }
        String itemString = matcher.group("item");
        if (itemString == null) {
            return ItemStack.field_190927_a;
        }
        String modid = matcher.group("modid");
        if (modid == null) {
            modid = "minecraft";
        }
        int damage = 0;
        String strDamage = matcher.group("damage");
        if (strDamage != null) {
            damage = strDamage.equals("*") ? Short.MAX_VALUE : ItemUtil.parse(matcher.group("damage"));
        }
        int n = size = matcher.group("size") == null ? 1 : ItemUtil.parse(matcher.group("size"));
        if (size == 0) {
            size = 1;
        }
        if ((item = Item.func_111206_d((String)(modid + ":" + itemString))) == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, size, damage);
    }

    public static int parse(String i) {
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            FMLLog.warning((String)("Invalid number : " + i), (Object[])new Object[0]);
            e.printStackTrace();
            return 0;
        }
    }
}

