/*
 * Decompiled with CFR 0.152.
 */
package lib.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Targetting {
    @SideOnly(value=Side.CLIENT)
    public static EntityLivingBase rayTraceClientSide(double parDistance) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.func_175606_aa() instanceof EntityLivingBase)) {
            return null;
        }
        EntityLivingBase viewEntity = (EntityLivingBase)mc.func_175606_aa();
        World worldObj = viewEntity.field_70170_p;
        EntityLivingBase Return = null;
        if (viewEntity != null) {
            RayTraceResult objectMouseOver = viewEntity.func_174822_a(parDistance, 0.5f);
            Vec3d playerPosition = viewEntity.func_174824_e(1.0f);
            double farDist = parDistance;
            if (objectMouseOver != null) {
                farDist = objectMouseOver.field_72307_f.func_72438_d(playerPosition);
            }
            double closest = farDist;
            Vec3d dirVec = viewEntity.func_70040_Z();
            Vec3d lookFar = playerPosition.func_72441_c(dirVec.field_72450_a * parDistance, dirVec.field_72448_b * parDistance, dirVec.field_72449_c * parDistance);
            List targettedEntities = worldObj.func_72872_a(EntityLivingBase.class, viewEntity.func_174813_aQ().func_72314_b(dirVec.field_72450_a * parDistance, dirVec.field_72448_b * parDistance, dirVec.field_72449_c * parDistance).func_72321_a(0.1, 0.1, 0.1));
            targettedEntities.remove(viewEntity);
            for (EntityLivingBase targettedEntity : targettedEntities) {
                if (targettedEntity == null) continue;
                double precheck = viewEntity.func_70068_e((Entity)targettedEntity);
                RayTraceResult mopElIntercept = targettedEntity.func_174813_aQ().func_72327_a(playerPosition, lookFar);
                if (mopElIntercept == null || !(precheck < closest)) continue;
                Return = targettedEntity;
                closest = precheck;
            }
        }
        if (Return != null && Return instanceof EntityLivingBase) {
            return Return;
        }
        return null;
    }

    private static RayTraceResult getEntityIntercept(EntityPlayer player, Vec3d start, Vec3d look, Vec3d end, RayTraceResult mop) {
        double distance = end.func_72438_d(start);
        if (mop != null) {
            distance = mop.field_72307_f.func_72438_d(start);
        }
        Vec3d direction = new Vec3d(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance);
        end = start.func_178787_e(direction);
        Vec3d hitPosition = null;
        List list = player.field_70170_p.func_175674_a((Entity)player, player.func_174813_aQ().func_72314_b(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c).func_72321_a(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, Entity::func_70067_L));
        double distanceToEntity = distance;
        Entity pointedEntity = null;
        for (Entity entity : list) {
            double interceptDistance;
            double border = entity.func_70111_Y();
            AxisAlignedBB bounds = entity.func_174813_aQ().func_72321_a(border, border, border);
            RayTraceResult intercept = bounds.func_72327_a(start, end);
            if (bounds.func_72318_a(start)) {
                if (!(distanceToEntity >= 0.0)) continue;
                pointedEntity = entity;
                hitPosition = intercept == null ? start : intercept.field_72307_f;
                distanceToEntity = 0.0;
                continue;
            }
            if (intercept == null || !((interceptDistance = start.func_72438_d(intercept.field_72307_f)) < distanceToEntity) && distanceToEntity != 0.0) continue;
            if (entity == player.func_184187_bx() && !player.canRiderInteract()) {
                if (distanceToEntity != 0.0) continue;
                pointedEntity = entity;
                hitPosition = intercept.field_72307_f;
                continue;
            }
            pointedEntity = entity;
            hitPosition = intercept.field_72307_f;
            distanceToEntity = interceptDistance;
        }
        if (pointedEntity != null && distanceToEntity < distance && start.func_72438_d(hitPosition) < distance) {
            return new RayTraceResult(pointedEntity, hitPosition);
        }
        return mop;
    }

    public static RayTraceResult rayTraceServerSide(EntityPlayer player, float partialTicks) {
        Vec3d start;
        float maxDistance = 10.0f;
        if (partialTicks < 1.0f) {
            double sx = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double sy = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks + (double)player.func_70047_e();
            double sz = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            start = new Vec3d(sx, sy, sz);
        } else {
            start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        }
        Vec3d look = player.func_70676_i(partialTicks);
        Vec3d end = start.func_72441_c(look.field_72450_a * (double)maxDistance, look.field_72448_b * (double)maxDistance, look.field_72449_c * (double)maxDistance);
        RayTraceResult mop = player.field_70170_p.func_147447_a(start, end, false, true, false);
        mop = Targetting.getEntityIntercept(player, start, look, end, mop);
        if (mop != null && mop.field_72307_f != null) {
            end = mop.field_72307_f;
        }
        return mop;
    }
}

