/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler.capability;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.internal.Vector3;

public class CADData
implements ICapabilityProvider,
ICADData {
    private int time;
    private int battery;
    private List<Vector3> vectors = Lists.newArrayList();
    private boolean dirty;

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CAPABILITY ? CAPABILITY.cast((Object)this) : null);
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int time) {
        if (this.time != time) {
            this.time = time;
        }
    }

    @Override
    public int getBattery() {
        return this.battery;
    }

    @Override
    public void setBattery(int battery) {
        this.battery = battery;
    }

    @Override
    public Vector3 getSavedVector(int memorySlot) {
        if (this.vectors.size() <= memorySlot) {
            return Vector3.zero.copy();
        }
        Vector3 vec = this.vectors.get(memorySlot);
        return (vec == null ? Vector3.zero : vec).copy();
    }

    @Override
    public void setSavedVector(int memorySlot, Vector3 value) {
        while (this.vectors.size() <= memorySlot) {
            this.vectors.add(null);
        }
        this.vectors.set(memorySlot, value);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public NBTTagCompound serializeForSynchronization() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("Time", this.time);
        compound.func_74768_a("Battery", this.battery);
        return compound;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = this.serializeForSynchronization();
        NBTTagList memory = new NBTTagList();
        for (Vector3 vector : this.vectors) {
            if (vector == null) {
                memory.func_74742_a((NBTBase)new NBTTagList());
                continue;
            }
            NBTTagList vec = new NBTTagList();
            vec.func_74742_a((NBTBase)new NBTTagDouble(vector.x));
            vec.func_74742_a((NBTBase)new NBTTagDouble(vector.y));
            vec.func_74742_a((NBTBase)new NBTTagDouble(vector.z));
            memory.func_74742_a((NBTBase)vec);
        }
        compound.func_74782_a("Memory", (NBTBase)memory);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("Time", 99)) {
            this.time = nbt.func_74762_e("Time");
        }
        if (nbt.func_150297_b("Battery", 99)) {
            this.battery = nbt.func_74762_e("Battery");
        }
        if (nbt.func_150297_b("Memory", 9)) {
            NBTTagList memory = nbt.func_150295_c("Memory", 9);
            ArrayList newVectors = Lists.newArrayList();
            for (int i = 0; i < memory.func_74745_c(); ++i) {
                NBTTagList vec = (NBTTagList)memory.func_179238_g(i);
                if (vec.func_150303_d() == 6 && vec.func_74745_c() >= 3) {
                    newVectors.add(new Vector3(vec.func_150309_d(0), vec.func_150309_d(1), vec.func_150309_d(2)));
                    continue;
                }
                newVectors.add(null);
            }
            this.vectors = newVectors;
        }
    }
}

