/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.psi.api.cad.ISocketableCapability;

public class SocketWheel
implements ISocketableCapability,
INBTSerializable<NBTTagCompound> {
    private final int size;
    private final ItemStackHandler handler;
    private int selectedSlot = 0;

    public SocketWheel() {
        this(12);
    }

    public SocketWheel(int size) {
        this.size = size;
        this.handler = new ItemStackHandler(size);
    }

    @Override
    public boolean isSocketSlotAvailable(int slot) {
        return slot < this.size;
    }

    @Override
    public ItemStack getBulletInSocket(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Override
    public void setBulletInSocket(int slot, ItemStack bullet) {
        this.handler.setStackInSlot(slot, bullet);
    }

    @Override
    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void setSelectedSlot(int slot) {
        this.selectedSlot = slot;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack bullet) {
        return this.handler.insertItem(slot, bullet, true).func_190926_b();
    }

    @Override
    public boolean canLoopcast(ItemStack stack) {
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = this.handler.serializeNBT();
        compound.func_82580_o("Size");
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Size", this.size);
        this.handler.deserializeNBT(nbt);
    }
}

