/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.ConfigHandler;

public class PieceTrickBreakBlock
extends PieceTrick {
    SpellParam position;

    public PieceTrickBreakBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 25);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        PieceTrickBreakBlock.removeBlockWithDrops(context, context.caster, context.caster.func_130014_f_(), context.tool, pos, true);
        return null;
    }

    public static void removeBlockWithDrops(SpellContext context, EntityPlayer player, World world, ItemStack tool, BlockPos pos, boolean particles) {
        IBlockState state;
        Block block;
        if (!world.func_175667_e(pos) || context.positionBroken != null && pos.equals((Object)context.positionBroken.func_178782_a()) || !world.func_175660_a(player, pos)) {
            return;
        }
        if (tool.func_190926_b()) {
            tool = PsiAPI.getPlayerCAD(player);
        }
        if (!(block = (state = world.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockAccess)world, pos) && !(block instanceof BlockLiquid) && !(block instanceof IFluidBlock) && state.func_185903_a(player, world, pos) > 0.0f) {
            if (!PieceTrickBreakBlock.canHarvestBlock(block, player, world, pos, tool)) {
                return;
            }
            BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, player, world, pos, tool);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    TileEntity tile = world.func_175625_s(pos);
                    if (block.removedByPlayer(state, world, pos, player, true)) {
                        block.func_176206_d(world, pos, state);
                        block.func_180657_a(world, player, pos, state, tile, tool);
                    }
                } else {
                    world.func_175698_g(pos);
                }
            }
            if (particles) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            }
        }
    }

    public static BlockEvent.BreakEvent createBreakEvent(IBlockState state, EntityPlayer player, World world, BlockPos pos, ItemStack tool) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        if (state == null || !PieceTrickBreakBlock.canHarvestBlock(state.func_177230_c(), player, world, pos, tool) || state.func_177230_c().canSilkHarvest(world, pos, world.func_180495_p(pos), player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) > 0) {
            event.setExpToDrop(0);
        } else {
            event.setExpToDrop(state.func_177230_c().getExpDrop(state, (IBlockAccess)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool)));
        }
        return event;
    }

    public static boolean canHarvestBlock(Block block, EntityPlayer player, World world, BlockPos pos, ItemStack tool) {
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        int reqLevel = block.getHarvestLevel(state);
        Item toolItem = tool.func_77973_b();
        if (tool.func_150998_b(state) || state.func_185904_a().func_76229_l() || ConfigHandler.cadHarvestLevel >= reqLevel) {
            return ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)player, (IBlockState)state, (boolean)true);
        }
        String reqTool = block.getHarvestTool(state);
        if (toolItem == Items.field_190931_a || reqTool == null) {
            return false;
        }
        if (toolItem.getHarvestLevel(tool, reqTool, player, state) >= reqLevel) {
            return ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)player, (IBlockState)state, (boolean)true);
        }
        return false;
    }
}

