/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client;

import com.google.common.collect.Maps;
import erogenousbeef.bigreactors.api.data.ReactantData;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelContainer;
import erogenousbeef.bigreactors.common.multiblock.helpers.ReactorFuelRodsLayout;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import it.zerono.mods.zerocore.lib.client.render.CachedRender;
import it.zerono.mods.zerocore.lib.math.Colour;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientReactorFuelRodsLayout
extends ReactorFuelRodsLayout {
    private FuelData[] _rodsFuelData;
    private float _totalFuelQuota = 0.0f;
    private float _totalWasteQuota = 0.0f;
    private Colour _fuelColor;
    private Colour _wasteColor = this._fuelColor = Colour.WHITE;
    private boolean _reactantsChanged = false;
    private Map<FuelRodFluidStatus, CachedRender> _renderCache;

    public ClientReactorFuelRodsLayout(@Nonnull MultiblockReactor reactor) {
        super(reactor);
        this._rodsFuelData = new FuelData[this.getRodLength()];
        for (int i = 0; i < this._rodsFuelData.length; ++i) {
            this._rodsFuelData[i] = new FuelData();
        }
        this._renderCache = Maps.newHashMapWithExpectedSize((int)4);
    }

    @Nullable
    public FuelData getFuelData(int fuelRodIndex) {
        return fuelRodIndex >= 0 && fuelRodIndex < this._rodsFuelData.length ? this._rodsFuelData[fuelRodIndex] : null;
    }

    public boolean isFuelDataChanged(int fuelRodIndex) {
        FuelData data = this.getFuelData(fuelRodIndex);
        return null != data && data.isChanged() || this._reactantsChanged;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Colour getFuelColor() {
        return this._fuelColor;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Colour getWasteColor() {
        return this._wasteColor;
    }

    public float getFuelQuota() {
        return this._totalFuelQuota;
    }

    public float getWasteQuota() {
        return this._totalWasteQuota;
    }

    public float getFuelRodFuelQuota() {
        return this._totalFuelQuota / (float)this.getRodLength();
    }

    public float getFuelRodWasteQuota() {
        return this._totalWasteQuota / (float)this.getRodLength();
    }

    @Override
    public void updateFuelData(@Nonnull FuelContainer fuelData, int fuelRodsTotalCount) {
        Colour oldFuelColor = this._fuelColor;
        Colour oldWasteColor = this._wasteColor;
        this._fuelColor = ClientReactorFuelRodsLayout.getReactantColor(fuelData.getFuelType(), 12368464);
        this._wasteColor = ClientReactorFuelRodsLayout.getReactantColor(fuelData.getWasteType(), 5083829);
        boolean bl = this._reactantsChanged = !this._fuelColor.equals((Object)oldFuelColor) || !this._wasteColor.equals((Object)oldWasteColor);
        if (this._reactantsChanged) {
            this._renderCache.clear();
        }
        int fuelRodsCount = Math.max(1, this.getRodLength());
        fuelRodsTotalCount = Math.max(1, fuelRodsTotalCount);
        this._totalFuelQuota = fuelData.getFuelAmount() / fuelRodsTotalCount * fuelRodsCount;
        this._totalWasteQuota = fuelData.getWasteAmount() / fuelRodsTotalCount * fuelRodsCount;
        if (EnumFacing.Axis.Y == this.getAxis()) {
            float rodCapacity = 4000.0f;
            float remainingWaste = this._totalWasteQuota;
            float remainingFuel = this._totalFuelQuota;
            for (int i = 0; i < fuelRodsCount; ++i) {
                float fuelAmount;
                float wasteAmount;
                if (remainingWaste > 0.0f) {
                    wasteAmount = Math.min(remainingWaste, 4000.0f);
                    remainingWaste -= wasteAmount;
                } else {
                    wasteAmount = 0.0f;
                }
                if (remainingFuel > 0.0f) {
                    fuelAmount = Math.min(remainingFuel, 4000.0f - wasteAmount);
                    remainingFuel -= fuelAmount;
                } else {
                    fuelAmount = 0.0f;
                }
                if (!this._rodsFuelData[i].update(fuelAmount, wasteAmount) || !this._renderCache.containsKey((Object)this._rodsFuelData[i].getFluidStatus())) continue;
                this._renderCache.remove((Object)this._rodsFuelData[i].getFluidStatus());
            }
        } else {
            float fuelPerRod = this._totalFuelQuota / (float)fuelRodsCount;
            float wastePerRod = this._totalWasteQuota / (float)fuelRodsCount;
            for (int i = 0; i < fuelRodsCount; ++i) {
                if (!this._rodsFuelData[i].update(fuelPerRod, wastePerRod) || !this._renderCache.containsKey((Object)this._rodsFuelData[i].getFluidStatus())) continue;
                this._renderCache.remove((Object)this._rodsFuelData[i].getFluidStatus());
            }
        }
    }

    @Override
    public void updateFuelRodsOcclusion(@Nonnull Set<TileEntityReactorFuelRod> fuelRods) {
        EnumFacing[] directions = this.getRadiateDirections();
        for (TileEntityReactorFuelRod fuelRod : fuelRods) {
            BlockPos rodPosition = fuelRod.getWorldPosition();
            boolean occluded = true;
            for (int i = 0; i < directions.length; ++i) {
                BlockPos checkPosition = rodPosition.func_177972_a(directions[i]);
                if (!fuelRod.func_145831_w().func_175623_d(checkPosition) && fuelRod.func_145831_w().func_180495_p(checkPosition).func_177230_c().func_180664_k() == BlockRenderLayer.SOLID) continue;
                occluded = false;
                break;
            }
            fuelRod.setOccluded(occluded);
        }
    }

    @Nullable
    public CachedRender getCachedRender(@Nonnull FuelRodFluidStatus rodStatus) {
        return this._renderCache.get((Object)rodStatus);
    }

    public void setChachedRender(@Nonnull FuelRodFluidStatus rodStatus, @Nonnull CachedRender render) {
        this._renderCache.put(rodStatus, render);
    }

    private static Colour getReactantColor(@Nullable String reactantName, int defaultColor) {
        if (null == reactantName || reactantName.isEmpty()) {
            return Colour.WHITE;
        }
        ReactantData reactant = Reactants.getReactant(reactantName);
        int color = null == reactant ? defaultColor : reactant.getColor();
        return Colour.fromARGB((int)(color | 0xFF000000));
    }

    public class FuelData {
        private float _fuelAmount = 0.0f;
        private float _wasteAmount = 0.0f;
        private float _fuelHeight = 0.0f;
        private float _wasteHeight = 0.0f;
        private boolean _changed = false;
        private FuelRodFluidStatus _fluidStatus = FuelRodFluidStatus.Empty;

        FuelData() {
        }

        public float getFuelAmount() {
            return this._fuelAmount;
        }

        public float getWasteAmount() {
            return this._wasteAmount;
        }

        public float getFuelHeight() {
            return this._fuelHeight;
        }

        public float getWasteHeight() {
            return this._wasteHeight;
        }

        public boolean isChanged() {
            return this._changed;
        }

        @Nonnull
        public FuelRodFluidStatus getFluidStatus() {
            return this._fluidStatus;
        }

        private boolean update(float fuelAmount, float wasteAmount) {
            this._changed = this._fuelAmount != fuelAmount || this._wasteAmount != wasteAmount;
            this._fuelAmount = fuelAmount;
            this._wasteAmount = wasteAmount;
            this._fuelHeight = this._fuelAmount / 4000.0f;
            this._wasteHeight = this._wasteAmount / 4000.0f;
            this._fluidStatus = 0.0 == (double)this._fuelAmount && 0.0 == (double)this._wasteAmount ? FuelRodFluidStatus.Empty : (4000.0f == this._fuelAmount ? FuelRodFluidStatus.FullFuelOnly : (4000.0f == this._wasteAmount ? FuelRodFluidStatus.FullWasteOnly : (0.0 < (double)this._fuelAmount && 0.0 == (double)this._wasteAmount ? FuelRodFluidStatus.FuelOnly : (0.0 < (double)this._wasteAmount && 0.0 == (double)this._fuelAmount ? FuelRodFluidStatus.WasteOnly : FuelRodFluidStatus.Mixed))));
            return this._changed;
        }
    }

    public static enum FuelRodFluidStatus {
        Empty,
        FuelOnly,
        WasteOnly,
        Mixed,
        FullFuelOnly,
        FullWasteOnly;

    }
}

