/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.utils.RayTraceUtils;
import com.buuz135.industrial.utils.RecipeUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinityDrill
extends IFCustomItem {
    public static Material[] mineableMaterials = new Material[]{Material.field_151574_g, Material.field_151571_B, Material.field_151592_s, Material.field_151577_b, Material.field_151578_c, Material.field_151588_w, Material.field_151573_f, Material.field_151598_x, Material.field_76233_E, Material.field_151576_e, Material.field_151595_p, Material.field_151597_y};
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 3;

    public ItemInfinityDrill() {
        super("infinity_drill");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.setHarvestLevel("pickaxe", Integer.MAX_VALUE);
        this.setHarvestLevel("shovel", Integer.MAX_VALUE);
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Item)this), new Object[]{" ID", "PRI", "PT ", Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('D'), Blocks.field_150484_ah, Character.valueOf('P'), ItemRegistry.pinkSlimeIngot, Character.valueOf('R'), BlockRegistry.laserDrillBlock, Character.valueOf('T'), BlockRegistry.blackHoleTankBlock});
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.addNbt(stack, 0L, 0, CommonProxy.CONTRIBUTORS.contains(playerIn.func_110124_au().toString()));
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 2;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.DIGGER;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (DrillTier value : DrillTier.values()) {
                items.add((Object)this.createStack(value.getPowerNeeded(), 0, false));
            }
            items.add((Object)this.createStack(DrillTier.ARTIFACT.getPowerNeeded(), 1000000, true));
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return Items.field_151046_w.func_150897_b(blockIn) || Items.field_151047_v.func_150897_b(blockIn);
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged && !oldStack.equals(newStack);
    }

    public int func_77626_a(ItemStack stack) {
        return 720000;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.enoughFuel(stack) ? 10.0f : 0.0f;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !oldStack.func_77969_a(newStack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new InfinityDrillCapabilityProvider(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (GuiScreen.func_146272_n()) {
            int fuel = this.getFuelFromStack(stack);
            return 1.0 - (double)fuel / 1000000.0;
        }
        long power = this.getPowerFromStack(stack);
        return 1.0 - (double)power / (double)((DrillTier)((Object)DrillTier.getTierBraquet(power).getRight())).getPowerNeeded();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return GuiScreen.func_146272_n() ? 13304063 : 53503;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        long power = this.getPowerFromStack(stack);
        Pair<DrillTier, DrillTier> braquet = DrillTier.getTierBraquet(power);
        DrillTier current = this.getSelectedDrillTier(stack);
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.current_area", new Object[0]).func_150260_c() + " " + this.getFormattedArea(current, current.getRadius()));
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.tier", new Object[0]).func_150260_c() + " " + ((DrillTier)((Object)braquet.getLeft())).getColor() + ((DrillTier)((Object)braquet.getLeft())).getLocalizedName());
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.power", new Object[0]).func_150260_c() + " " + new DecimalFormat().format(power) + "/" + new DecimalFormat().format(((DrillTier)((Object)braquet.getRight())).getPowerNeeded()) + "RF " + new TextComponentTranslation("text.industrialforegoing.display.next_tier", new Object[0]).func_150260_c());
        int fuelAmount = this.getFuelFromStack(stack);
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.fluid", new Object[0]).func_150260_c() + " " + new DecimalFormat().format(fuelAmount) + "/" + new DecimalFormat().format(1000000L) + " mb " + new TextComponentTranslation(FluidsRegistry.BIOFUEL.getUnlocalizedName(), new Object[0]).func_150261_e());
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.max_area", new Object[0]).func_150260_c() + " " + this.getFormattedArea((DrillTier)((Object)braquet.getLeft()), ((DrillTier)((Object)braquet.getLeft())).getRadius()));
        if (this.isSpecial(stack)) {
            tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.special", new Object[0]).func_150254_d());
        }
    }

    public long getPowerFromStack(ItemStack stack) {
        long power = 0L;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Energy")) {
            power = stack.func_77978_p().func_74763_f("Energy");
        }
        return power;
    }

    public int getFuelFromStack(ItemStack stack) {
        int fuelAmount = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid") && stack.func_77978_p().func_74775_l("Fluid").func_74764_b("Amount")) {
            fuelAmount = stack.func_77978_p().func_74775_l("Fluid").func_74762_e("Amount");
        }
        return fuelAmount;
    }

    public boolean isSpecial(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Special") && stack.func_77978_p().func_74767_n("Special");
    }

    public ItemStack createStack(long power, int fuel, boolean special) {
        ItemStack stack = new ItemStack((Item)this);
        this.addNbt(stack, power, fuel, special);
        return stack;
    }

    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74772_a("Energy", power);
        NBTTagCompound fluid = new NBTTagCompound();
        fluid.func_74778_a("FluidName", "biofuel");
        fluid.func_74768_a("Amount", fuel);
        tagCompound.func_74782_a("Fluid", (NBTBase)fluid);
        tagCompound.func_74757_a("Special", special);
        tagCompound.func_74778_a("Selected", ((DrillTier)((Object)DrillTier.getTierBraquet(power).getLeft())).name());
        stack.func_77982_d(tagCompound);
    }

    private String getFormattedArea(DrillTier tier, int radius) {
        int diameter = radius * 2 + 1;
        return diameter + "x" + diameter + "x" + (tier == DrillTier.ARTIFACT ? diameter : 1);
    }

    private boolean enoughFuel(ItemStack stack) {
        return this.getFuelFromStack(stack) >= FUEL_CONSUMPTION || this.getPowerFromStack(stack) >= (long)POWER_CONSUMPTION;
    }

    private void consumeFuel(ItemStack stack) {
        if (this.getFuelFromStack(stack) >= FUEL_CONSUMPTION) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid") && stack.func_77978_p().func_74775_l("Fluid").func_74764_b("Amount")) {
                stack.func_77978_p().func_74775_l("Fluid").func_74768_a("Amount", this.getFuelFromStack(stack) - FUEL_CONSUMPTION);
            }
        } else {
            stack.func_77978_p().func_74772_a("Energy", stack.func_77978_p().func_74763_f("Energy") - (long)POWER_CONSUMPTION);
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            RayTraceResult rayTraceResult = RayTraceUtils.rayTraceSimple(worldIn, entityLiving, 16.0, 0.0f);
            EnumFacing facing = rayTraceResult.field_178784_b;
            DrillTier currentTier = this.getSelectedDrillTier(stack);
            Pair<BlockPos, BlockPos> area = this.getArea(pos, facing, currentTier, true);
            BlockPos.func_177980_a((BlockPos)((BlockPos)area.getLeft()), (BlockPos)((BlockPos)area.getRight())).forEach(blockPos -> {
                if (this.enoughFuel(stack) && worldIn.func_175625_s(blockPos) == null && entityLiving instanceof EntityPlayerMP && !worldIn.func_175623_d(blockPos)) {
                    IBlockState tempState = worldIn.func_180495_p(blockPos);
                    Block block = tempState.func_177230_c();
                    if (block.func_176195_g(tempState, worldIn, blockPos) < 0.0f) {
                        return;
                    }
                    int xp = ForgeHooks.onBlockBreakEvent((World)worldIn, (GameType)((EntityPlayerMP)entityLiving).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)entityLiving), (BlockPos)blockPos);
                    if (xp >= 0 && block.removedByPlayer(tempState, worldIn, blockPos, (EntityPlayer)entityLiving, true)) {
                        block.func_176206_d(worldIn, blockPos, tempState);
                        block.func_180657_a(worldIn, (EntityPlayer)entityLiving, blockPos, tempState, null, stack);
                        block.func_180637_b(worldIn, blockPos, xp);
                        this.consumeFuel(stack);
                    }
                }
            });
            worldIn.func_72872_a(EntityItem.class, new AxisAlignedBB((BlockPos)area.getLeft(), (BlockPos)area.getRight()).func_186662_g(1.0)).forEach(entityItem -> {
                entityItem.func_70634_a(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                entityItem.func_174867_a(0);
            });
            worldIn.func_72872_a(EntityXPOrb.class, new AxisAlignedBB((BlockPos)area.getLeft(), (BlockPos)area.getRight()).func_186662_g(1.0)).forEach(entityXPOrb -> entityXPOrb.func_70634_a(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v));
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public DrillTier getSelectedDrillTier(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Selected") ? DrillTier.valueOf(stack.func_77978_p().func_74779_i("Selected")) : (DrillTier)((Object)DrillTier.getTierBraquet(this.getPowerFromStack(stack)).getLeft());
    }

    public void setSelectedDrillTier(ItemStack stack, DrillTier tier) {
        stack.func_77978_p().func_74778_a("Selected", tier.name());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        if (player.func_70093_af()) {
            player.func_184185_a(SoundEvents.field_187750_dc, 0.5f, 0.5f);
            ItemStack stack = player.func_184586_b(handIn);
            DrillTier next = this.getSelectedDrillTier(stack).getNext((DrillTier)((Object)DrillTier.getTierBraquet(this.getPowerFromStack(stack)).getLeft()));
            player.func_146105_b((ITextComponent)new TextComponentString(new TextComponentTranslation("text.industrialforegoing.display.current_area", new Object[0]).func_150260_c() + " " + this.getFormattedArea(next, next.getRadius())), true);
            this.setSelectedDrillTier(stack, next);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public Pair<BlockPos, BlockPos> getArea(BlockPos pos, EnumFacing facing, DrillTier currentTier, boolean withDepth) {
        int radius = currentTier.radius;
        BlockPos bottomLeft = pos.func_177967_a(facing.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.SOUTH : EnumFacing.DOWN, radius).func_177967_a(facing.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.WEST : facing.func_176735_f(), radius);
        BlockPos topRight = pos.func_177967_a(facing.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.UP, radius).func_177967_a(facing.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.EAST : facing.func_176746_e(), radius);
        if (facing.func_176740_k() != EnumFacing.Axis.Y && radius > 0) {
            bottomLeft = bottomLeft.func_177967_a(EnumFacing.UP, radius - 1);
            topRight = topRight.func_177967_a(EnumFacing.UP, radius - 1);
        }
        if (currentTier == DrillTier.ARTIFACT && withDepth) {
            topRight = topRight.func_177967_a(facing.func_176734_d(), radius);
        }
        return Pair.of((Object)bottomLeft, (Object)topRight);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            DrillTier drillTier = (DrillTier)((Object)DrillTier.getTierBraquet(this.getPowerFromStack(stack)).getLeft());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(2 + drillTier.getRadius()), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.5, 0));
        }
        return multimap;
    }

    public void configuration(Configuration config) {
        int i = 0;
        for (DrillTier value : DrillTier.values()) {
            value.setPowerNeeded(Long.parseLong(config.getString(i + "_" + value.name, "general.infinity_drill.power_values", value.powerNeeded + "", "")));
            value.setRadius(config.getInt(i + "_" + value.name, "general.infinity_drill.radius", value.radius, 0, Integer.MAX_VALUE, ""));
            ++i;
        }
    }

    private class InfinityDrillEnergyStorage
    implements IEnergyStorage {
        private final long capacity = DrillTier.ARTIFACT.getPowerNeeded();
        private long energy = 0L;

        public int receiveEnergy(int maxReceive, boolean simulate) {
            long stored = this.getLongEnergyStored();
            int energyReceived = (int)Math.min(this.capacity - stored, Math.min(Long.MAX_VALUE, (long)maxReceive));
            if (!simulate) {
                this.setEnergyStored(stored + (long)energyReceived);
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return (int)this.energy;
        }

        public void setEnergyStored(long power) {
            this.energy = power;
        }

        public int getMaxEnergyStored() {
            return this.capacity > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.capacity;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public long getLongEnergyStored() {
            return this.energy;
        }
    }

    private class InfinityDrillCapabilityProvider
    implements ICapabilityProvider {
        private final FluidHandlerItemStack tank;
        private final InfinityDrillEnergyStorage energyStorage;

        private InfinityDrillCapabilityProvider(final ItemStack stack) {
            this.tank = new FluidHandlerItemStack(stack, 1000000){

                public boolean canFillFluidType(FluidStack fluid) {
                    return fluid != null && fluid.getFluid() != null && fluid.getFluid().equals((Object)FluidsRegistry.BIOFUEL);
                }

                public boolean canDrainFluidType(FluidStack fluid) {
                    return false;
                }
            };
            this.energyStorage = new InfinityDrillEnergyStorage(){

                @Override
                public long getLongEnergyStored() {
                    if (stack.func_77942_o()) {
                        return Math.min(stack.func_77978_p().func_74763_f("Energy"), DrillTier.ARTIFACT.getPowerNeeded());
                    }
                    return 0L;
                }

                @Override
                public void setEnergyStored(long energy) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74772_a("Energy", Math.min(energy, DrillTier.ARTIFACT.getPowerNeeded()));
                }
            };
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY || capability == CapabilityEnergy.ENERGY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)this.tank;
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)this.energyStorage;
            }
            return null;
        }
    }

    public static enum DrillTier {
        POOR("poor", 0L, 0, TextFormatting.GRAY, 0x7C7C7A),
        COMMON("common", 4000000L, 1, TextFormatting.WHITE, 0xFFFFFF),
        UNCOMMON("uncommon", 16000000L, 2, TextFormatting.GREEN, 1894425),
        RARE("rare", 80000000L, 3, TextFormatting.BLUE, 34815),
        EPIC("epic", 480000000L, 4, TextFormatting.DARK_PURPLE, 14745855),
        LEGENDARY("legendary", 3360000000L, 5, TextFormatting.GOLD, 0xFFAA00),
        ARTIFACT("artifact", Long.MAX_VALUE, 6, TextFormatting.YELLOW, 0xFFF887);

        private final String name;
        private final TextFormatting color;
        private final int textureColor;
        private long powerNeeded;
        private int radius;

        private DrillTier(String name, long powerNeeded, int radius, TextFormatting color, int textureColor) {
            this.name = name;
            this.powerNeeded = powerNeeded;
            this.radius = radius;
            this.color = color;
            this.textureColor = textureColor;
        }

        public static Pair<DrillTier, DrillTier> getTierBraquet(long power) {
            DrillTier lastTier = POOR;
            for (DrillTier drillTier : DrillTier.values()) {
                if (power >= lastTier.getPowerNeeded() && power < drillTier.getPowerNeeded()) {
                    return Pair.of((Object)((Object)lastTier), (Object)((Object)drillTier));
                }
                lastTier = drillTier;
            }
            return Pair.of((Object)((Object)ARTIFACT), (Object)((Object)ARTIFACT));
        }

        public String getLocalizedName() {
            return new TextComponentTranslation("text.industrialforegoing.tooltip.infinitydrill." + this.name, new Object[0]).func_150260_c();
        }

        public String getName() {
            return this.name;
        }

        public long getPowerNeeded() {
            return this.powerNeeded;
        }

        public void setPowerNeeded(long powerNeeded) {
            this.powerNeeded = powerNeeded;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public int getTextureColor() {
            return this.textureColor;
        }

        public DrillTier getNext(DrillTier maxTier) {
            DrillTier lastTier = POOR;
            for (DrillTier drillTier : DrillTier.values()) {
                if (drillTier == POOR) continue;
                if (lastTier == maxTier) {
                    return POOR;
                }
                if (this == lastTier) {
                    return drillTier;
                }
                lastTier = drillTier;
            }
            return POOR;
        }
    }
}

