/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.jei.extractor;

import com.buuz135.industrial.jei.extractor.ExtractorRecipeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ExtractorRecipeCategory
implements IRecipeCategory<ExtractorRecipeWrapper> {
    public static String UID = "EXTRACTOR_RECIPE";
    private IGuiHelper guiHelper;
    private IDrawable tankOverlay;

    public ExtractorRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.tankOverlay = guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 1, 207, 12, 48);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return "Tree Fluid Extractor";
    }

    public String getModName() {
        return "Industrial Foregoing";
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 27, 76, 50, 0, 0, 0, 74);
    }

    public void setRecipe(IRecipeLayout recipeLayout, ExtractorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(0, true, 0, 16);
        IGuiFluidStackGroup guiFluidStackGroup = recipeLayout.getFluidStacks();
        guiFluidStackGroup.init(1, false, 57, 1, 12, 48, Math.max(50, ((FluidStack)((List)ingredients.getOutputs(FluidStack.class).get((int)0)).get((int)0)).amount), false, this.tankOverlay);
        guiItemStackGroup.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        guiFluidStackGroup.set(1, (List)ingredients.getOutputs(FluidStack.class).get(0));
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX >= 18 && mouseX <= 58) {
            return Arrays.asList("Production rate");
        }
        if (mouseX >= 78 && mouseX <= 120 && mouseY >= 25 && mouseY <= 45) {
            return Arrays.asList("Average numbers aren't real numbers");
        }
        return new ArrayList<String>();
    }

    public void drawExtras(Minecraft minecraft) {
    }
}

