/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.qnb;

import appeng.api.AEApi;
import appeng.block.qnb.BlockQuantumBase;
import appeng.block.qnb.QnbFormedState;
import appeng.client.render.cablebus.CubeBuilder;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

class QnbFormedBakedModel
implements IBakedModel {
    private static final ResourceLocation TEXTURE_LINK = new ResourceLocation("appliedenergistics2", "blocks/quantum_link");
    private static final ResourceLocation TEXTURE_RING = new ResourceLocation("appliedenergistics2", "blocks/quantum_ring");
    private static final ResourceLocation TEXTURE_RING_LIGHT = new ResourceLocation("appliedenergistics2", "blocks/quantum_ring_light");
    private static final ResourceLocation TEXTURE_RING_LIGHT_CORNER = new ResourceLocation("appliedenergistics2", "blocks/quantum_ring_light_corner");
    private static final ResourceLocation TEXTURE_CABLE_GLASS = new ResourceLocation("appliedenergistics2", "parts/cable/glass/transparent");
    private static final ResourceLocation TEXTURE_COVERED_CABLE = new ResourceLocation("appliedenergistics2", "parts/cable/covered/transparent");
    private static final float DEFAULT_RENDER_MIN = 2.0f;
    private static final float DEFAULT_RENDER_MAX = 14.0f;
    private static final float CORNER_POWERED_RENDER_MIN = 3.9f;
    private static final float CORNER_POWERED_RENDER_MAX = 12.1f;
    private static final float CENTER_POWERED_RENDER_MIN = -0.01f;
    private static final float CENTER_POWERED_RENDER_MAX = 16.01f;
    private final VertexFormat vertexFormat;
    private final IBakedModel baseModel;
    private final Block linkBlock;
    private final TextureAtlasSprite linkTexture;
    private final TextureAtlasSprite ringTexture;
    private final TextureAtlasSprite glassCableTexture;
    private final TextureAtlasSprite coveredCableTexture;
    private final TextureAtlasSprite lightTexture;
    private final TextureAtlasSprite lightCornerTexture;

    public QnbFormedBakedModel(VertexFormat vertexFormat, IBakedModel baseModel, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.vertexFormat = vertexFormat;
        this.baseModel = baseModel;
        this.linkTexture = bakedTextureGetter.apply(TEXTURE_LINK);
        this.ringTexture = bakedTextureGetter.apply(TEXTURE_RING);
        this.glassCableTexture = bakedTextureGetter.apply(TEXTURE_CABLE_GLASS);
        this.coveredCableTexture = bakedTextureGetter.apply(TEXTURE_COVERED_CABLE);
        this.lightTexture = bakedTextureGetter.apply(TEXTURE_RING_LIGHT);
        this.lightCornerTexture = bakedTextureGetter.apply(TEXTURE_RING_LIGHT_CORNER);
        this.linkBlock = AEApi.instance().definitions().blocks().quantumLink().maybeBlock().orElse(null);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (!(state instanceof IExtendedBlockState)) {
            return this.baseModel.func_188616_a(state, side, rand);
        }
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        QnbFormedState formedState = (QnbFormedState)extendedBlockState.getValue((IUnlistedProperty)BlockQuantumBase.FORMED_STATE);
        return this.getQuads(formedState, state, side, rand);
    }

    private List<BakedQuad> getQuads(QnbFormedState formedState, IBlockState state, EnumFacing side, long rand) {
        CubeBuilder builder;
        block4: {
            block5: {
                block3: {
                    builder = new CubeBuilder(this.vertexFormat);
                    if (state.func_177230_c() != this.linkBlock) break block3;
                    Set<EnumFacing> sides = formedState.getAdjacentQuantumBridges();
                    this.renderCableAt(builder, 1.76f, this.glassCableTexture, 2.256f, sides);
                    this.renderCableAt(builder, 3.008f, this.coveredCableTexture, 3.0f, sides);
                    builder.setTexture(this.linkTexture);
                    builder.addCube(2.0f, 2.0f, 2.0f, 14.0f, 14.0f, 14.0f);
                    break block4;
                }
                if (!formedState.isCorner()) break block5;
                this.renderCableAt(builder, 3.008f, this.coveredCableTexture, 0.8f, formedState.getAdjacentQuantumBridges());
                builder.setTexture(this.ringTexture);
                builder.addCube(2.0f, 2.0f, 2.0f, 14.0f, 14.0f, 14.0f);
                if (!formedState.isPowered()) break block4;
                builder.setTexture(this.lightCornerTexture);
                builder.setRenderFullBright(true);
                for (EnumFacing facing : EnumFacing.values()) {
                    float xOffset = Math.abs((float)facing.func_82601_c() * 0.01f);
                    float yOffset = Math.abs((float)facing.func_96559_d() * 0.01f);
                    float zOffset = Math.abs((float)facing.func_82599_e() * 0.01f);
                    builder.setDrawFaces(EnumSet.of(facing));
                    builder.addCube(2.0f - xOffset, 2.0f - yOffset, 2.0f - zOffset, 14.0f + xOffset, 14.0f + yOffset, 14.0f + zOffset);
                }
                break block4;
            }
            builder.setTexture(this.ringTexture);
            builder.addCube(0.0f, 2.0f, 2.0f, 16.0f, 14.0f, 14.0f);
            builder.addCube(2.0f, 0.0f, 2.0f, 14.0f, 16.0f, 14.0f);
            builder.addCube(2.0f, 2.0f, 0.0f, 14.0f, 14.0f, 16.0f);
            if (formedState.isPowered()) {
                builder.setTexture(this.lightTexture);
                builder.setRenderFullBright(true);
                for (EnumFacing facing : EnumFacing.values()) {
                    float xOffset = Math.abs((float)facing.func_82601_c() * 0.01f);
                    float yOffset = Math.abs((float)facing.func_96559_d() * 0.01f);
                    float zOffset = Math.abs((float)facing.func_82599_e() * 0.01f);
                    builder.setDrawFaces(EnumSet.of(facing));
                    builder.addCube(-xOffset, -yOffset, -zOffset, 16.0f + xOffset, 16.0f + yOffset, 16.0f + zOffset);
                }
            }
        }
        return builder.getOutput();
    }

    private void renderCableAt(CubeBuilder builder, float thickness, TextureAtlasSprite texture, float pull, Set<EnumFacing> connections) {
        builder.setTexture(texture);
        if (connections.contains(EnumFacing.WEST)) {
            builder.addCube(0.0f, 8.0f - thickness, 8.0f - thickness, 8.0f - thickness - pull, 8.0f + thickness, 8.0f + thickness);
        }
        if (connections.contains(EnumFacing.EAST)) {
            builder.addCube(8.0f + thickness + pull, 8.0f - thickness, 8.0f - thickness, 16.0f, 8.0f + thickness, 8.0f + thickness);
        }
        if (connections.contains(EnumFacing.NORTH)) {
            builder.addCube(8.0f - thickness, 8.0f - thickness, 0.0f, 8.0f + thickness, 8.0f + thickness, 8.0f - thickness - pull);
        }
        if (connections.contains(EnumFacing.SOUTH)) {
            builder.addCube(8.0f - thickness, 8.0f - thickness, 8.0f + thickness + pull, 8.0f + thickness, 8.0f + thickness, 16.0f);
        }
        if (connections.contains(EnumFacing.DOWN)) {
            builder.addCube(8.0f - thickness, 0.0f, 8.0f - thickness, 8.0f + thickness, 8.0f - thickness - pull, 8.0f + thickness);
        }
        if (connections.contains(EnumFacing.UP)) {
            builder.addCube(8.0f - thickness, 8.0f + thickness + pull, 8.0f - thickness, 8.0f + thickness, 16.0f, 8.0f + thickness);
        }
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.baseModel.func_188617_f();
    }

    public static List<ResourceLocation> getRequiredTextures() {
        return ImmutableList.of((Object)TEXTURE_LINK, (Object)TEXTURE_RING, (Object)TEXTURE_CABLE_GLASS, (Object)TEXTURE_COVERED_CABLE, (Object)TEXTURE_RING_LIGHT, (Object)TEXTURE_RING_LIGHT_CORNER);
    }
}

