/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.blocks.IPowered;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class TileEntityLightSwitch
extends TileEntity {
    private final List<BlockPos> lights = NonNullList.func_191196_a();

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("lights", 9)) {
            this.lights.clear();
            NBTTagList tagList = compound.func_150295_c("lights", 4);
            tagList.forEach(nbtBase -> this.addLight(((NBTTagLong)nbtBase).func_150291_c()));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList tagList = new NBTTagList();
        this.lights.forEach(blockPos -> tagList.func_74742_a((NBTBase)new NBTTagLong(blockPos.func_177986_g())));
        compound.func_74782_a("lights", (NBTBase)tagList);
        return compound;
    }

    private void addLight(long pos) {
        BlockPos lightPos = BlockPos.func_177969_a((long)pos);
        if (!this.lights.contains(lightPos)) {
            this.lights.add(lightPos);
        }
    }

    public void addLight(BlockPos lightPos) {
        if (!this.lights.contains(lightPos)) {
            this.lights.add(lightPos);
        }
    }

    public void setState(boolean powered) {
        this.lights.removeIf(lightPos -> {
            IBlockState state = this.field_145850_b.func_180495_p(lightPos);
            return !(state.func_177230_c() instanceof IPowered);
        });
        this.lights.forEach(lightPos -> {
            IBlockState state = this.field_145850_b.func_180495_p(lightPos);
            ((IPowered)state.func_177230_c()).setPowered(this.field_145850_b, (BlockPos)lightPos, powered);
        });
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (powered) {
            this.field_145850_b.func_175656_a(this.field_174879_c, FurnitureBlocks.LIGHT_SWITCH_ON.func_176223_P().func_177226_a((IProperty)BlockFurniture.FACING, state.func_177229_b((IProperty)BlockFurniture.FACING)));
        } else {
            this.field_145850_b.func_175656_a(this.field_174879_c, FurnitureBlocks.LIGHT_SWITCH_OFF.func_176223_P().func_177226_a((IProperty)BlockFurniture.FACING, state.func_177229_b((IProperty)BlockFurniture.FACING)));
        }
        this.func_145829_t();
        this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)this);
    }
}

