/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.apiimpl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.api.screens.IScreenModuleRegistry;
import mcjty.rftools.api.screens.data.IModuleDataFactory;
import mcjty.rftools.blocks.screens.data.ModuleDataBoolean;
import mcjty.rftools.blocks.screens.data.ModuleDataInteger;
import mcjty.rftools.blocks.screens.data.ModuleDataString;
import mcjty.rftools.blocks.screens.modules.ComputerScreenModule;
import mcjty.rftools.blocks.screens.modules.ElevatorButtonScreenModule;
import mcjty.rftools.blocks.screens.modules.ItemStackScreenModule;
import mcjty.rftools.blocks.screens.modules.ScreenModuleHelper;
import mcjty.rftools.blocks.screens.modules.StorageControlScreenModule;

public class ScreenModuleRegistry
implements IScreenModuleRegistry {
    private Map<String, IModuleDataFactory<?>> dataFactoryMap = new HashMap();
    private Map<String, Integer> idToIntMap = null;
    private Map<Integer, String> inttoIdMap = null;

    public void registerBuiltins() {
        this.dataFactoryMap.put("rftools:bool", ModuleDataBoolean::new);
        this.dataFactoryMap.put("rftools:integer", ModuleDataInteger::new);
        this.dataFactoryMap.put("rftools:string", ModuleDataString::new);
        this.dataFactoryMap.put("rftools:contents", ScreenModuleHelper.ModuleDataContents::new);
        this.dataFactoryMap.put("rftools:itemStacks", ItemStackScreenModule.ModuleDataStacks::new);
        this.dataFactoryMap.put("rftools:storage", StorageControlScreenModule.ModuleDataStacks::new);
        this.dataFactoryMap.put("rftools:elevator", ElevatorButtonScreenModule.ModuleElevatorInfo::new);
        this.dataFactoryMap.put("rftools:computer", ComputerScreenModule.ModuleComputerInfo::new);
    }

    @Override
    public void registerModuleDataFactory(String id, IModuleDataFactory<?> dataFactory) {
        this.dataFactoryMap.put(id, dataFactory);
    }

    @Override
    public IModuleDataFactory<?> getModuleDataFactory(String id) {
        return this.dataFactoryMap.get(id);
    }

    public String getNormalId(int i) {
        this.createIdMap();
        return this.inttoIdMap.get(i);
    }

    public int getShortId(String id) {
        this.createIdMap();
        return this.idToIntMap.get(id);
    }

    private void createIdMap() {
        if (this.idToIntMap == null) {
            this.idToIntMap = new HashMap<String, Integer>();
            this.inttoIdMap = new HashMap<Integer, String>();
            ArrayList<String> strings = new ArrayList<String>(this.dataFactoryMap.keySet());
            strings.sort(Comparator.naturalOrder());
            int idx = 0;
            for (String s : strings) {
                this.idToIntMap.put(s, idx);
                this.inttoIdMap.put(idx, s);
                ++idx;
            }
        }
    }
}

