/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery.tileentity;

import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockValidationException;
import com.bymarcin.zettaindustries.mods.battery.tileentity.BasicRectangularMultiblockTileEntityBase;
import com.bymarcin.zettaindustries.mods.battery.tileentity.BatteryController;
import com.bymarcin.zettaindustries.mods.battery.tileentity.TileEntityPowerTap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")})
public class TileEntityComputerPort
extends BasicRectangularMultiblockTileEntityBase
implements SimpleComponent {
    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Controller may only be placed in the battery side", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Controller may only be placed in the battery side", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Controller may only be placed in the battery side", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Controller may only be placed in the battery side", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    public String getComponentName() {
        return "big_battery";
    }

    private BatteryController getControler() {
        return (BatteryController)this.getMultiblockController();
    }

    private TileEntityPowerTap findPowerTap(int id) {
        if (this.getControler() != null) {
            TileEntityPowerTap[] array = this.getControler().getPowerTaps().toArray(new TileEntityPowerTap[0]);
            if (id >= 0 && id < array.length) {
                return array[id];
            }
        }
        return null;
    }

    private TileEntityPowerTap findPowerTap(String label) {
        if (this.getControler() != null) {
            TileEntityPowerTap[] array = this.getControler().getPowerTaps().toArray(new TileEntityPowerTap[0]);
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].getLabel().equals(label)) continue;
                return array[i];
            }
        }
        return null;
    }

    @Callback(doc="function(name:string) - set power tap as input")
    @Optional.Method(modid="opencomputers")
    public Object[] setIn(Context c, Arguments args) {
        TileEntityPowerTap powerTap;
        String name = null;
        int id = -1;
        if (args.isString(0)) {
            name = args.checkString(0);
        } else {
            id = args.checkInteger(0);
        }
        TileEntityPowerTap tileEntityPowerTap = powerTap = name != null ? this.findPowerTap(name) : this.findPowerTap(id);
        if (powerTap != null) {
            powerTap.setIn();
            return null;
        }
        return new Object[]{null, "Electrode or Controller not found."};
    }

    @Callback(doc="function(name:string) - set power tap as output")
    @Optional.Method(modid="opencomputers")
    public Object[] setOut(Context c, Arguments args) {
        TileEntityPowerTap powerTap;
        String name = null;
        int id = -1;
        if (args.isString(0)) {
            name = args.checkString(0);
        } else {
            id = args.checkInteger(0);
        }
        TileEntityPowerTap tileEntityPowerTap = powerTap = name != null ? this.findPowerTap(name) : this.findPowerTap(id);
        if (powerTap != null) {
            powerTap.setOut();
            return null;
        }
        return new Object[]{null, "Electrode or Controller not found."};
    }

    @Callback(doc="function():number - returns how much energy is stored")
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyStored(Context c, Arguments args) {
        if (this.getControler() != null) {
            return new Object[]{this.getControler().getStorage().getRealEnergyStored()};
        }
        return new Object[]{null, "Controller block not found. Rebuild your battery."};
    }

    @Callback(doc="function():number - returns how much energy can be stored")
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxEnergyStored(Context c, Arguments args) {
        if (this.getControler() != null) {
            return new Object[]{this.getControler().getStorage().getRealMaxEnergyStored()};
        }
        return new Object[]{null, "Controler block not found. Rebuild your battery."};
    }

    @Callback(doc="function(name:string, transfer:number) - set transfer for electrode")
    @Optional.Method(modid="opencomputers")
    public Object[] setElectrodeTransfer(Context c, Arguments args) {
        TileEntityPowerTap powerTap;
        String label = null;
        int id = -1;
        if (args.isString(0)) {
            label = args.checkString(0);
        } else {
            id = args.checkInteger(0);
        }
        int transfer = args.checkInteger(1);
        TileEntityPowerTap tileEntityPowerTap = powerTap = label != null ? this.findPowerTap(label) : this.findPowerTap(id);
        if (powerTap != null) {
            powerTap.setTransfer(transfer);
            return null;
        }
        return new Object[]{null, "Electrode or Controller not found."};
    }

    @Callback(doc="function(transfer:number) - set transfer for all electrodes")
    @Optional.Method(modid="opencomputers")
    public Object[] setAllElectrodeTransfer(Context c, Arguments args) {
        int transfer = args.checkInteger(0);
        if (this.getControler() != null) {
            for (TileEntityPowerTap tap : this.getControler().getPowerTaps()) {
                tap.setTransfer(transfer);
            }
            return null;
        }
        return new Object[]{null, "Controller block not found. Rebuild your battery."};
    }

    @Callback(doc="function():number - get max transfer for electrode")
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxElectrodeTransfer(Context c, Arguments args) {
        if (this.getControler() != null) {
            return new Object[]{this.getControler().getStorage().getMaxExtract()};
        }
        return new Object[]{null, "Controller block not found. Rebuild your battery."};
    }

    @Callback(doc="function():number - get energy balance from last tick(1/20s)")
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyBalanceLastTick(Context c, Arguments args) {
        if (this.getControler() != null) {
            return new Object[]{this.getControler().getLastTickBalance()};
        }
        return new Object[]{null, "Controller block not found. Rebuild your battery."};
    }
}

