/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.nfc.smartcard;

import com.bymarcin.zettaindustries.mods.nfc.smartcard.IDyeableItem;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SmartCardDyeRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public final Ingredient input;

    public SmartCardDyeRecipe(Ingredient ingredient) {
        this.input = ingredient;
    }

    protected int[] getColor(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof IDyeableItem) {
                IDyeableItem targetItem = (IDyeableItem)stack.func_77973_b();
                if (targetItem.hasColor(stack)) {
                    int c = targetItem.getColor(stack);
                    return new int[]{c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF};
                }
            } else {
                Optional dyeId = DyeUtils.colorFromStack((ItemStack)stack);
                if (dyeId.isPresent()) {
                    float[] col = ((EnumDyeColor)dyeId.get()).func_193349_f();
                    return new int[]{(int)(col[0] * 255.0f), (int)(col[1] * 255.0f), (int)(col[2] * 255.0f)};
                }
            }
        }
        return null;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack target = ItemStack.field_190927_a;
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack source = inv.func_70301_a(i);
            if (source.func_190926_b()) continue;
            if (this.input.apply(source)) {
                if (!target.func_190926_b()) {
                    return false;
                }
                target = source;
                continue;
            }
            if (this.getColor(source) != null) {
                dyes.add(source);
                continue;
            }
            return false;
        }
        return !target.func_190926_b() && !dyes.isEmpty();
    }

    protected Optional<Integer> getMixedColor(InventoryCrafting inv, ItemStack base, Predicate<Integer> slotFilter) {
        int[] col;
        int[] color = new int[3];
        int scale = 0;
        int count = 0;
        if (!base.func_190926_b() && (col = this.getColor(base)) != null) {
            scale += Math.max(col[0], Math.max(col[1], col[2]));
            color[0] = color[0] + col[0];
            color[1] = color[1] + col[1];
            color[2] = color[2] + col[2];
            ++count;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            int[] col2;
            ItemStack source;
            if (slotFilter != null && !slotFilter.test(i) || (source = inv.func_70301_a(i)).func_190926_b() || source == base || (col2 = this.getColor(source)) == null) continue;
            scale += Math.max(col2[0], Math.max(col2[1], col2[2]));
            color[0] = color[0] + col2[0];
            color[1] = color[1] + col2[1];
            color[2] = color[2] + col2[2];
            ++count;
        }
        if (count > 0) {
            int i1 = color[0] / count;
            int j1 = color[1] / count;
            int k1 = color[2] / count;
            float f3 = (float)scale / (float)count;
            float f4 = Math.max(i1, Math.max(j1, k1));
            i1 = (int)((float)i1 * f3 / f4);
            j1 = (int)((float)j1 * f3 / f4);
            k1 = (int)((float)k1 * f3 / f4);
            return Optional.of((i1 << 16) + (j1 << 8) + k1);
        }
        return Optional.empty();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        Optional<Integer> result;
        ItemStack target = ItemStack.field_190927_a;
        IDyeableItem targetItem = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack source = inv.func_70301_a(i);
            if (source.func_190926_b() || !(source.func_77973_b() instanceof IDyeableItem)) continue;
            targetItem = (IDyeableItem)source.func_77973_b();
            target = source.func_77946_l();
            target.func_190920_e(1);
        }
        if (targetItem != null && (result = this.getMixedColor(inv, target, null)).isPresent()) {
            targetItem.setColor(target, result.get());
            return target;
        }
        return null;
    }

    public boolean func_194133_a(int i, int i1) {
        return i * i1 > 1;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }
}

