/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.nfc.smartcard;

import com.bymarcin.zettaindustries.mods.nfc.NFC;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardItem;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.KeyAgreement;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Analyzable;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.TileEntityEnvironment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;

public class SmartCardTerminalTileEntity
extends TileEntityEnvironment
implements Analyzable,
ITickable {
    @Nonnull
    ItemStack card = ItemStack.field_190927_a;
    UUID playerUUID;
    boolean needsUpdate = true;
    NBTTagCompound renderInfo = null;

    public SmartCardTerminalTileEntity() {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withConnector().withComponent("smartcard_terminal", Visibility.Network).create();
    }

    public boolean onBlockActivated(EntityPlayer player) {
        if (this.card.func_190926_b() && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof SmartCardItem) {
            this.card = player.func_184614_ca().func_77946_l();
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            this.playerUUID = player.func_110124_au();
            if (this.node != null) {
                this.node.sendToReachable("computer.signal", new Object[]{"smartcard_in", player.func_70005_c_()});
            }
            this.needsUpdate = true;
        }
        if (!this.card.func_190926_b() && player.func_184614_ca().func_190926_b()) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.card);
            this.playerUUID = null;
            this.card = ItemStack.field_190927_a;
            if (this.node != null) {
                this.node.sendToReachable("computer.signal", new Object[]{"smartcard_out", player.func_70005_c_()});
            }
            this.needsUpdate = true;
        }
        return true;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 666, this.getData());
    }

    public NBTTagCompound func_189517_E_() {
        return this.getData();
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.renderInfo = tag;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.renderInfo = pkt.func_148857_g();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.needsUpdate) {
            this.needsUpdate = false;
            this.func_70296_d();
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 2);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.playerUUID != null) {
            nbt.func_186854_a("PLAYERUUID", this.playerUUID);
        }
        if (!this.card.func_190926_b()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.card.func_77955_b(tag);
            nbt.func_74782_a("CARD", (NBTBase)tag);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("PLAYERUUIDLeast")) {
            this.playerUUID = nbt.func_186857_a("PLAYERUUID");
        } else if (nbt.func_74764_b("PLAYERUUID")) {
            this.playerUUID = UUID.fromString(nbt.func_74779_i("PLAYERUUID"));
        }
        this.card = nbt.func_74764_b("CARD") ? new ItemStack(nbt.func_74775_l("CARD")) : ItemStack.field_190927_a;
    }

    protected void checkCost(Double baseCost) throws Exception {
        if (!((Connector)this.node).tryChangeBuffer(-baseCost.doubleValue())) {
            throw new Exception("not enough energy");
        }
    }

    protected byte[] checkCost(Context context, Arguments args, double baseCost, double byteCost) throws Exception {
        byte[] data = args.checkByteArray(0);
        if (data.length > NFC.dataCardHardLimit) {
            throw new IllegalArgumentException("data size limit exceeded");
        }
        double cost = baseCost + (double)data.length * byteCost;
        if (!((Connector)this.node).tryChangeBuffer(-cost)) {
            throw new Exception("not enough energy");
        }
        if (data.length > NFC.dataCardSoftLimit) {
            context.pause((double)NFC.dataCardTimeout);
        }
        return data;
    }

    protected byte[] asymmetricCost(Context context, Arguments args) throws Exception {
        return this.checkCost(context, args, NFC.dataCardAsymmetric, NFC.dataCardComplexByte);
    }

    @Callback(direct=true)
    public Object[] hasCard(Context ctx, Arguments args) {
        Object[] objectArray;
        if (this.card.func_190926_b()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = false;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = true;
        }
        return objectArray;
    }

    @Callback(direct=true, limit=1, doc="function(pub:userdata):string -- Generates a shared key. ecdh(a.priv, b.pub) == ecdh(b.priv, a.pub)")
    public Object[] ecdh(Context context, Arguments args) throws Exception {
        if (this.card.func_190926_b()) {
            return new Object[]{null, "Card expected"};
        }
        if (SmartCardItem.getNBT(this.card).func_74764_b("sc:owner_uuidLeast") && !SmartCardItem.getOwner(this.card).equals(this.playerUUID)) {
            return new Object[]{null, "You are not owner"};
        }
        this.checkCost(NFC.dataCardAsymmetric);
        Key pubKey = this.deserialize(KeyType.PUBLIC, args.checkByteArray(0));
        Key privKey = this.deserialize(KeyType.PRIVATE, SmartCardItem.getPrivateKey(this.card));
        KeyAgreement ka = KeyAgreement.getInstance("ECDH");
        ka.init(privKey);
        ka.doPhase(pubKey, true);
        return new Object[]{ka.generateSecret()};
    }

    @Callback(direct=true)
    public Object[] protect(Context ctx, Arguments args) {
        if (!this.card.func_190926_b() && !SmartCardItem.getNBT(this.card).func_74764_b("sc:owner_uuidLeast")) {
            SmartCardItem.getNBT(this.card).func_186854_a("sc:owner_uuid", this.playerUUID);
            this.needsUpdate = true;
            return new Object[]{true, this.playerUUID};
        }
        return new Object[]{false};
    }

    @Callback(direct=true, limit=1, doc="function(data:string [, sig:string]):string or bool -- Signs or verifies data.")
    public Object[] ecdsa(Context context, Arguments args) throws Exception {
        if (this.card.func_190926_b()) {
            return new Object[]{null, "Card expected"};
        }
        if (SmartCardItem.getNBT(this.card).func_74764_b("sc:owner_uuidLeast") && !SmartCardItem.getOwner(this.card).equals(this.playerUUID)) {
            return new Object[]{null, "You are not owner"};
        }
        byte[] data = this.asymmetricCost(context, args);
        byte[] sig = args.optByteArray(1, null);
        Signature sign = Signature.getInstance("SHA256withECDSA");
        if (sig != null) {
            byte[] key = SmartCardItem.getPublicKey(this.card);
            sign.initVerify((PublicKey)this.deserialize(KeyType.PUBLIC, key));
            sign.update(data);
            return new Object[]{sign.verify(sig)};
        }
        byte[] key = SmartCardItem.getPrivateKey(this.card);
        sign.initSign((PrivateKey)this.deserialize(KeyType.PRIVATE, key));
        sign.update(data);
        return new Object[]{sign.sign()};
    }

    @Callback(direct=true, doc="function():string")
    public Object[] getPublicKey(Context context, Arguments args) throws Exception {
        if (this.card.func_190926_b()) {
            return new Object[]{null, "Card expected"};
        }
        return new Object[]{SmartCardItem.getPublicKey(this.card)};
    }

    private Key deserialize(KeyType type, byte[] data) throws InvalidKeySpecException, NoSuchAlgorithmException {
        switch (type) {
            case PRIVATE: {
                return KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec(data));
            }
            case PUBLIC: {
                return KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(data));
            }
        }
        throw new IllegalArgumentException("invalid key type, must be public or private");
    }

    public NBTTagCompound getData() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("hasCard", !this.card.func_190926_b());
        if (!this.card.func_190926_b() && SmartCardItem.getOwner(this.card) == null || !this.card.func_190926_b() && this.playerUUID != null && this.playerUUID.equals(SmartCardItem.getOwner(this.card))) {
            nbt.func_74757_a("validOwner", true);
            nbt.func_74757_a("isProtected", SmartCardItem.getOwner(this.card) != null);
        } else {
            nbt.func_74757_a("validOwner", false);
        }
        return nbt;
    }

    public Node[] onAnalyze(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        return new Node[]{this.node};
    }

    static enum KeyType {
        PRIVATE,
        PUBLIC;

    }
}

