/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.rfpowermeter.render;

import com.bymarcin.zettaindustries.mods.rfpowermeter.render.RFMeterRender;
import com.bymarcin.zettaindustries.utils.render.BaseBakedModel;
import com.bymarcin.zettaindustries.utils.render.CustomFaceBakery;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.Vector3f;

public class RFMeterModel
extends BaseBakedModel {
    List<BakedQuad> quadsBackground = new LinkedList<BakedQuad>();
    List<BakedQuad> quadsNumberUP = new LinkedList<BakedQuad>();
    List<BakedQuad> quadsNumberDown = new LinkedList<BakedQuad>();
    List<BakedQuad> finalQuads = new LinkedList<BakedQuad>();
    long numberUP;
    long numberDOWN;
    public static ResourceLocation cTexture1 = new ResourceLocation("zettaindustries", "blocks/counter");
    ModelRotation rotation;
    ModelRotation rotationOpposite;
    TextureAtlasSprite texture;
    BakedQuad[] si = new BakedQuad[RFMeterRender.SI.values().length - 1];
    BakedQuad[] direction = new BakedQuad[2];
    int color;
    int colorDark;

    public RFMeterModel(EnumFacing facing, EnumDyeColor color) {
        this.texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(cTexture1.toString());
        this.color = color.func_193350_e();
        this.color = 0xFF000000 | this.color >> 16 & 0xFF | (this.color >> 8 & 0xFF) << 8 | (this.color & 0xFF) << 16;
        this.colorDark = 0xFF000000 | (int)((double)(this.color >> 16 & 0xFF) * 0.3) << 16 | (int)((double)(this.color >> 8 & 0xFF) * 0.3) << 8 | (int)((double)(this.color & 0xFF) * 0.3);
        switch (facing) {
            case WEST: {
                this.rotation = ModelRotation.X0_Y0;
                this.rotationOpposite = ModelRotation.X0_Y180;
                break;
            }
            case EAST: {
                this.rotation = ModelRotation.X0_Y180;
                this.rotationOpposite = ModelRotation.X0_Y0;
                break;
            }
            case NORTH: {
                this.rotation = ModelRotation.X0_Y90;
                this.rotationOpposite = ModelRotation.X0_Y270;
                break;
            }
            case SOUTH: {
                this.rotation = ModelRotation.X0_Y270;
                this.rotationOpposite = ModelRotation.X0_Y90;
            }
        }
        this.quadsBackground.add(CustomFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(2.999f, 12.0f, 4.0f), new Vector3f(2.999f, 14.0f, 12.0f), this.color, new float[]{0.0f, 2.75f, 10.75f, 5.5f}, this.texture, EnumFacing.WEST, this.rotation, true));
        this.quadsBackground.add(CustomFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(2.999f, 9.0f, 4.0f), new Vector3f(2.999f, 11.0f, 12.0f), this.color, new float[]{0.0f, 2.75f, 10.75f, 5.5f}, this.texture, EnumFacing.WEST, this.rotation, true));
        this.quadsBackground.add(CustomFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(2.999f, 5.0f, 4.0f), new Vector3f(2.999f, 7.0f, 12.0f), this.colorDark, new float[]{6.5f, 10.0f, 13.75f, 11.75f}, this.texture, EnumFacing.WEST, this.rotation, true));
        this.cacheSI();
        float[] up = new float[]{14.0f, 10.0f, 15.5f, 11.75f};
        float[] down = new float[]{15.5f, 11.75f, 14.0f, 10.0f};
        this.direction[0] = CustomFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(2.999f, 2.0f, 7.0f), new Vector3f(2.999f, 4.0f, 9.0f), this.color, down, this.texture, EnumFacing.WEST, this.rotation, false);
        this.direction[1] = CustomFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(2.999f, 2.0f, 7.0f), new Vector3f(2.999f, 4.0f, 9.0f), this.color, up, this.texture, EnumFacing.WEST, this.rotation, false);
    }

    private void cacheSI() {
        float siSize = 1.5f;
        float startTex = 6.5f;
        for (RFMeterRender.SI si : RFMeterRender.SI.values()) {
            if (si == RFMeterRender.SI.none) continue;
            float textMin = startTex + siSize * (float)(RFMeterRender.SI.K.ordinal() - si.ordinal());
            this.si[si.ordinal()] = CustomFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(2.998f, 5.0f, 4.0f + 1.655f * (float)(RFMeterRender.SI.K.ordinal() - si.ordinal())), new Vector3f(2.998f, 7.0f, 4.0f + 1.655f * (float)(RFMeterRender.SI.K.ordinal() - si.ordinal() + 1)), this.color, new float[]{textMin, 10.0f, textMin + siSize, 11.75f}, this.texture, EnumFacing.WEST, this.rotation, true);
        }
    }

    public void setNumber(long numberUP, long numberDOWN, RFMeterRender.SI si, boolean inverted) {
        this.numberUP = numberUP;
        this.numberDOWN = numberDOWN;
        this.finalQuads.clear();
        this.generateNumber(this.quadsNumberUP, numberUP, false, 9.0f);
        this.generateNumber(this.quadsNumberDown, numberDOWN, true, 12.0f);
        if (si != RFMeterRender.SI.none) {
            this.finalQuads.add(this.si[si.ordinal()]);
        }
        if (inverted) {
            this.finalQuads.add(this.direction[1]);
        } else {
            this.finalQuads.add(this.direction[0]);
        }
        this.finalQuads.addAll(this.quadsBackground);
        this.finalQuads.addAll(this.quadsNumberUP);
        this.finalQuads.addAll(this.quadsNumberDown);
    }

    public List<BakedQuad> generateNumber(List<BakedQuad> quads, long number, boolean dot, float posFrom) {
        quads.clear();
        float offset = 3.8f;
        for (int i = 0; number != 0L || i < (dot ? 1 : 2); number /= 10L, ++i) {
            long dig = number % 10L;
            long x = dig * 6L;
            quads.add(CustomFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(13.002f, posFrom, offset), new Vector3f(13.002f, posFrom + 2.0f, offset + 1.125f), this.color, new float[]{(float)x / 4.0f, 0.0f, (float)(x + 6L) / 4.0f, 2.75f}, this.texture, EnumFacing.EAST, this.rotationOpposite, true));
            offset += 1.125f;
            if (i != 0) continue;
            if (dot) {
                quads.add(CustomFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(13.002f, 9.0f, offset), new Vector3f(13.002f, 11.0f, offset + 0.375f), this.color, new float[]{15.0f, 0.0f, 15.5f, 2.75f}, this.texture, EnumFacing.EAST, this.rotationOpposite, true));
            }
            offset += 0.375f;
        }
        return quads;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == EnumFacing.NORTH) {
            return this.finalQuads;
        }
        return Collections.EMPTY_LIST;
    }
}

