/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.utils.render;

import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.util.vector.Vector3f;

public class RenderUtils {
    public static float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }

    public static float[] calculateUV(Vector3f from, Vector3f to, EnumFacing facing1) {
        EnumFacing facing = facing1;
        if (facing == null) {
            if (from.y == to.y) {
                facing = EnumFacing.UP;
            } else if (from.x == to.x) {
                facing = EnumFacing.EAST;
            } else if (from.z == to.z) {
                facing = EnumFacing.SOUTH;
            } else {
                return null;
            }
        }
        switch (facing) {
            case DOWN: {
                return new float[]{from.x, 16.0f - to.z, to.x, 16.0f - from.z};
            }
            case UP: {
                return new float[]{from.x, from.z, to.x, to.z};
            }
            case NORTH: {
                return new float[]{16.0f - to.x, 16.0f - to.y, 16.0f - from.x, 16.0f - from.y};
            }
            case SOUTH: {
                return new float[]{from.x, 16.0f - to.y, to.x, 16.0f - from.y};
            }
            case WEST: {
                return new float[]{from.z, 16.0f - to.y, to.z, 16.0f - from.y};
            }
            case EAST: {
                return new float[]{16.0f - to.z, 16.0f - to.y, 16.0f - from.z, 16.0f - from.y};
            }
        }
        return null;
    }

    public static BakedQuad recolorQuad(BakedQuad quad, int color) {
        int c = DefaultVertexFormats.field_176600_a.func_177340_e() / 4;
        int v = DefaultVertexFormats.field_176600_a.func_177338_f() / 4;
        int[] vertexData = quad.func_178209_a();
        for (int i = 0; i < 4; ++i) {
            vertexData[v * i + c] = MathHelper.func_180188_d((int)vertexData[v * i + c], (int)color);
        }
        return quad;
    }

    public static BakedQuad clone(BakedQuad quad) {
        return new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    public static void addRecoloredQuads(List<BakedQuad> src, int color, List<BakedQuad> target, EnumFacing facing) {
        for (BakedQuad quad : src) {
            BakedQuad quad1 = RenderUtils.clone(quad);
            int c = DefaultVertexFormats.field_176600_a.func_177340_e() / 4;
            int v = DefaultVertexFormats.field_176600_a.func_177338_f() / 4;
            int[] vertexData = quad1.func_178209_a();
            for (int i = 0; i < 4; ++i) {
                vertexData[v * i + c] = MathHelper.func_180188_d((int)vertexData[v * i + c], (int)color);
            }
            target.add(quad1);
        }
    }
}

