/*
 * Decompiled with CFR 0.152.
 */
package murlen.util.fscript;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import murlen.util.fscript.FSException;
import murlen.util.fscript.FSObject;
import murlen.util.fscript.FSParserExtension;
import murlen.util.fscript.FSUnsupportedException;
import murlen.util.fscript.Parser;
import murlen.util.fscript.introspection.IntrospectorBase;

public class FSReflectionExtension
implements FSParserExtension {
    Parser parser;
    IntrospectorBase introspector = new IntrospectorBase();
    ExceptionHandler exceptionHandler = new ExceptionHandler(){

        @Override
        public void handle(String name, Exception exc) throws FSException {
            throw new FSException("Error calling method " + name + " " + exc.getMessage());
        }
    };
    FSObject nullObj = new FSObject(null);

    @Override
    public void setParser(Parser parser) {
        this.parser = parser;
    }

    @Override
    public Object getVar(String name) throws FSException {
        int pos = name.indexOf(46);
        if (pos > 0) {
            String oname = name.substring(0, pos);
            name = name.substring(pos + 1);
            Object object = this.parser.getVar(oname);
            if (object != null && object instanceof FSObject) {
                if ((object = ((FSObject)object).getObject()) == null) {
                    throw new FSException("variable " + oname + " is null");
                }
                return this.getObjectVar(object, name);
            }
        }
        throw new FSUnsupportedException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVar(String name, Object value) throws FSException {
        int pos = name.indexOf(46);
        if (pos <= 0) throw new FSUnsupportedException();
        String oname = name.substring(0, pos);
        name = name.substring(pos + 1);
        Object object = this.parser.getVar(oname);
        if (object == null || !(object instanceof FSObject)) throw new FSUnsupportedException();
        if ((object = ((FSObject)object).getObject()) == null) {
            throw new FSException("variable " + oname + " is null");
        }
        this.setObjectVar(object, name, value);
    }

    @Override
    public Object getVar(String name, Object index) throws FSException {
        return null;
    }

    @Override
    public void setVar(String name, Object index, Object value) throws FSException {
    }

    @Override
    public Object callFunction(String name, ArrayList params) throws FSException {
        int pos = name.indexOf(46);
        if (pos > 0) {
            String oname = name.substring(0, pos);
            name = name.substring(pos + 1);
            Object object = this.parser.getVar(oname);
            if (object != null && object instanceof FSObject) {
                if ((object = ((FSObject)object).getObject()) == null) {
                    throw new FSException("variable " + oname + " is null");
                }
                return this.objectMethod(object, name, params.toArray());
            }
        } else {
            if (name.equals("create")) {
                ArrayList cParams = (ArrayList)params.clone();
                cParams.remove(0);
                return this.createObject(params.get(0).toString(), cParams);
            }
            if (name.equals("getClass")) {
                return new FSObject(this.getClass((String)params.get(0)));
            }
            if (name.equals("null")) {
                return new FSObject(null, this.getClass((String)params.get(0)));
            }
        }
        throw new FSUnsupportedException();
    }

    protected Object objectMethod(Object target, String methodName, Object[] params) throws FSException {
        Method method = null;
        try {
            Class<?> c = target instanceof Class ? (Class<?>)target : target.getClass();
            method = this.introspector.getMethod(c, methodName, params);
        }
        catch (Exception ex) {
            throw new FSException("Error calling method " + methodName + ex.getMessage());
        }
        if (method == null) {
            throw new FSReflectionException("Error method " + methodName + " does not exists or ambigous");
        }
        try {
            Object[] params2 = new Object[params.length];
            for (int i = params.length - 1; i >= 0; --i) {
                Object obj = params[i];
                if (obj instanceof FSObject) {
                    obj = ((FSObject)obj).getObject();
                }
                params2[i] = obj;
            }
            return this.normalizeObj(method.invoke(target, params2), method.getReturnType());
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(methodName, ex);
            return this.nullObj;
        }
    }

    private Object createObject(String className, ArrayList params) throws FSException {
        try {
            Class c = this.getClass(className);
            if (c == null) {
                return null;
            }
            Object[] o = new Object[params.size()];
            for (int i = 0; i < o.length; ++i) {
                Object tmpObj = params.get(i);
                o[i] = tmpObj instanceof FSObject ? ((FSObject)tmpObj).getObject() : tmpObj;
            }
            Constructor<?>[] constructors = c.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Class[] classes = constructors[i].getParameterTypes();
                if (!this.checkMethods(classes, o)) continue;
                return this.normalizeObj(constructors[i].newInstance(o), c);
            }
        }
        catch (Exception e) {
            throw new FSException("Error Creating new object " + e.getMessage());
        }
        return null;
    }

    private Class getClass(String name) throws FSException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            throw new FSException("Error getting class " + name + " " + e.getMessage());
        }
    }

    protected void setObjectVar(Object o, String name, Object value) throws FSException {
        Object[] arr = new Object[]{value};
        try {
            this.objectMethod(o, "set" + name, arr);
        }
        catch (FSReflectionException ex) {
            if (value instanceof FSObject) {
                value = ((FSObject)value).getObject();
            }
            Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
            Field f = null;
            try {
                f = c.getField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (f != null) {
                try {
                    f.set(o, value);
                }
                catch (Exception e) {
                    throw new FSException("Could not access " + name + " " + e.getMessage());
                }
            }
            throw ex;
        }
    }

    protected Object getObjectVar(Object o, String name) throws FSException {
        try {
            return this.objectMethod(o, "get" + name, new Object[0]);
        }
        catch (FSReflectionException ex) {
            Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
            Field f = null;
            try {
                f = c.getField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (f != null) {
                try {
                    return this.normalizeObj(f.get(o), f.getType());
                }
                catch (Exception e) {
                    throw new FSException("Could not access " + name + " " + e.getMessage());
                }
            }
            throw ex;
        }
    }

    private boolean checkMethods(Class[] c, Object[] o) {
        if (c.length != o.length) {
            return false;
        }
        int len = c.length;
        for (int n = 0; n < len; ++n) {
            if (c[n].isInstance(o[n]) || c[n].equals(Integer.TYPE) && o[n] instanceof Integer || c[n].equals(Double.TYPE) && o[n] instanceof Double) continue;
            return false;
        }
        return true;
    }

    private Object normalizeObj(Object o, Class c) {
        if (o instanceof Integer || o instanceof String || o instanceof Double) {
            return o;
        }
        return new FSObject(o, c);
    }

    public void setExceptionHandler(ExceptionHandler eh) {
        this.exceptionHandler = eh;
    }

    public class FSReflectionException
    extends FSException {
        public FSReflectionException() {
        }

        public FSReflectionException(String msg) {
            super(msg);
        }
    }

    public static interface ExceptionHandler {
        public void handle(String var1, Exception var2) throws FSException;
    }
}

