/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.morph;

import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.morph.api.ability.Ability;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.handler.AbilityHandler;
import me.ichun.mods.morph.common.morph.MorphState;
import me.ichun.mods.morph.common.morph.MorphVariant;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MorphInfo {
    public static final UUID MORPH_HEALTH_ID = UUID.fromString("965EEABB-8AD4-381E-8313-59FBCBAF16D6");
    protected EntityPlayer player;
    public MorphState prevState;
    public MorphState nextState;
    public int morphTime;
    public boolean firstUpdate = true;
    public boolean wasSleeping;

    public MorphInfo(EntityPlayer player, MorphState prevState, MorphState nextState) {
        this.player = player;
        this.prevState = prevState;
        this.nextState = nextState;
        if (prevState == null) {
            this.morphTime = Morph.config.morphTime;
        }
    }

    public void tick() {
        if (this.firstUpdate) {
            this.firstUpdate = false;
            if (this.isMorphing() && this.prevState == null) {
                this.morphTime = Morph.config.morphTime;
            }
            if (this.prevState != null && this.prevState.entInstance != null) {
                this.syncEntityWithPlayer(this.prevState.entInstance);
            }
            if (this.nextState.entInstance != null) {
                this.syncEntityWithPlayer(this.nextState.entInstance);
            }
        }
        if (this.isMorphing()) {
            ++this.morphTime;
            if (!this.isMorphing()) {
                if (this.prevState.abilities != null) {
                    for (Ability ability : this.prevState.abilities) {
                        ability.kill(this.nextState.abilities != null ? this.nextState.abilities : new ArrayList<Ability>());
                    }
                }
                this.prevState = null;
            }
            this.setPlayerHealth();
            this.setPlayerBoundingBox();
        }
        float morphTransition = this.getMorphTransitionProgress(0.0f);
        if (this.prevState != null && this.prevState.entInstance != null && this.isMorphing()) {
            if ((float)this.morphTime / (float)Morph.config.morphTime < 0.5f) {
                this.prevState.entInstance.func_70071_h_();
            }
            this.syncEntityWithPlayer(this.prevState.entInstance);
            for (Ability ability : this.prevState.abilities) {
                ability.setParent((EntityLivingBase)this.getPlayer());
                if (ability.getParent() == null) continue;
                if (this.nextState.abilities == null || !AbilityHandler.getInstance().hasAbility(this.nextState.abilities, ability.type)) {
                    ability.strength = 1.0f - morphTransition;
                }
                ability.tick();
            }
        }
        if (this.nextState.entInstance != null) {
            if ((float)this.morphTime / (float)Morph.config.morphTime >= 0.5f) {
                this.nextState.entInstance.func_70071_h_();
            }
            this.syncEntityWithPlayer(this.nextState.entInstance);
            for (Ability ability : this.nextState.abilities) {
                ability.setParent((EntityLivingBase)this.getPlayer());
                if (ability.getParent() == null) continue;
                ability.strength = this.isMorphing() ? (this.prevState != null && this.prevState.abilities != null && AbilityHandler.getInstance().hasAbility(this.prevState.abilities, ability.type) ? 1.0f : morphTransition) : 1.0f;
                ability.tick();
            }
        }
        if (this.player != null) {
            if (this.wasSleeping && !this.player.func_70608_bn()) {
                this.setPlayerBoundingBox();
            }
            this.wasSleeping = this.player.func_70608_bn();
        }
    }

    public void syncEntityWithPlayer(EntityLivingBase ent) {
        if (this.player == null) {
            return;
        }
        ent.field_70165_t = this.player.field_70165_t;
        ent.field_70163_u = -500.0;
        ent.field_70161_v = this.player.field_70161_v;
        ent.field_71093_bK = this.player.field_71093_bK;
        ent.field_70170_p = this.player.func_130014_f_();
        ent.func_70606_j(ent.func_110138_aP() * (this.player.func_110143_aJ() / this.player.func_110138_aP()));
        ent.field_70144_Y = 1.0f;
    }

    public void setPlayer(@Nonnull EntityPlayer player) {
        this.player = player;
        if (this.nextState.entInstance instanceof EntityLiving) {
            ((EntityLiving)this.nextState.entInstance).func_184641_n(player.func_184591_cq() == EnumHandSide.LEFT);
        }
        this.setPlayerHealth();
        this.setPlayerBoundingBox();
        if (this.prevState != null && this.prevState.abilities != null) {
            for (Ability ability : this.prevState.abilities) {
                ability.setParent((EntityLivingBase)this.player);
                ability.init();
            }
        }
        if (this.nextState.abilities != null) {
            for (Ability ability : this.nextState.abilities) {
                ability.setParent((EntityLivingBase)this.player);
                ability.init();
            }
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setPlayerHealth() {
        if (this.player == null || Morph.config.morphHealthBalancing == 0) {
            return;
        }
        AttributeModifier amm = this.createAttributeModifier();
        AttributeModifier current = this.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(MORPH_HEALTH_ID);
        if (current == null || current.func_111164_d() != amm.func_111164_d()) {
            this.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_188479_b(MORPH_HEALTH_ID);
            this.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(amm);
        }
    }

    public AttributeModifier createAttributeModifier() {
        float morphTransition = this.getMorphTransitionProgress(0.0f);
        int calcHealth = 20;
        if (this.prevState != null) {
            double prevStateHealth = 20.0;
            double nextStateHealth = 20.0;
            if (!this.prevState.currentVariant.entId.startsWith("player:") && this.prevState.currentVariant.entTag.func_74764_b("Morph_HealthBalancing")) {
                prevStateHealth = this.prevState.currentVariant.entTag.func_74769_h("Morph_HealthBalancing");
            }
            if (!this.nextState.currentVariant.entId.startsWith("player:") && this.nextState.currentVariant.entTag.func_74764_b("Morph_HealthBalancing")) {
                nextStateHealth = this.nextState.currentVariant.entTag.func_74769_h("Morph_HealthBalancing");
            }
            calcHealth = Math.max(1, (int)Math.round(prevStateHealth + (double)morphTransition * (nextStateHealth - prevStateHealth)));
        } else {
            double nextStateHealth = 20.0;
            if (!this.nextState.currentVariant.entId.startsWith("player:") && this.nextState.currentVariant.entTag.func_74764_b("Morph_HealthBalancing")) {
                nextStateHealth = this.nextState.currentVariant.entTag.func_74769_h("Morph_HealthBalancing");
            }
            calcHealth = Math.max(1, (int)nextStateHealth);
        }
        return new AttributeModifier(MORPH_HEALTH_ID, "Morph health modifier", (double)calcHealth - 20.0, 0);
    }

    public void setPlayerBoundingBox() {
        if (this.player == null) {
            return;
        }
        if (this.prevState != null) {
            float morphTransition = this.getMorphTransitionProgress(0.0f);
            EntityLivingBase prevEnt = this.prevState.getEntInstance(this.player.func_130014_f_());
            EntityLivingBase nextEnt = this.nextState.getEntInstance(this.player.func_130014_f_());
            float newWidth = EntityHelper.interpolateValues((float)prevEnt.field_70130_N, (float)nextEnt.field_70130_N, (float)morphTransition);
            float newHeight = EntityHelper.interpolateValues((float)prevEnt.field_70131_O, (float)nextEnt.field_70131_O, (float)morphTransition);
            MorphInfo.setPlayerSize(this.player, this, newWidth, newHeight);
            this.player.eyeHeight = EntityHelper.interpolateValues((float)prevEnt.func_70047_e(), (float)nextEnt.func_70047_e(), (float)morphTransition);
            if (this.nextState.entInstance instanceof EntityLiving) {
                ((EntityLiving)this.nextState.entInstance).func_184641_n(this.player.func_184591_cq() == EnumHandSide.LEFT);
            }
        } else {
            EntityLivingBase nextEnt = this.nextState.getEntInstance(this.player.func_130014_f_());
            MorphInfo.setPlayerSize(this.player, this, nextEnt.field_70130_N, nextEnt.field_70131_O);
            this.player.eyeHeight = nextEnt.func_70047_e();
            if (this.nextState.entInstance instanceof EntityLiving) {
                ((EntityLiving)this.nextState.entInstance).func_184641_n(this.player.func_184591_cq() == EnumHandSide.LEFT);
            }
        }
    }

    public static void setPlayerSize(EntityPlayer player, MorphInfo info, float width, float height) {
        float f = (float)(player.func_174813_aQ().field_72336_d - player.func_174813_aQ().field_72340_a);
        if ((double)Math.abs(f - width) < 1.0E-5 && Math.abs(player.func_174813_aQ().field_72337_e - player.func_174813_aQ().field_72338_b - (double)height) < 1.0E-5) {
            return;
        }
        double d0 = (double)width / 2.0;
        player.func_174826_a(new AxisAlignedBB(player.field_70165_t - d0, player.field_70163_u, player.field_70161_v - d0, player.field_70165_t + d0, player.field_70163_u + (double)height, player.field_70161_v + d0));
        if ((float)(player.func_174813_aQ().field_72336_d - player.func_174813_aQ().field_72340_a) < f) {
            return;
        }
        boolean collidedHorizontally = player.field_70123_F;
        boolean collidedVertically = player.field_70124_G;
        boolean onGround = player.field_70122_E;
        boolean collided = player.field_70132_H;
        float difference = (float)(player.func_174813_aQ().field_72336_d - player.func_174813_aQ().field_72340_a) - f;
        float distanceWalkedModified = player.field_70140_Q;
        float distanceWalkedOnStepModified = player.field_82151_R;
        if (!player.field_70170_p.field_72995_K || info.isMorphing()) {
            player.func_70091_d(MoverType.SELF, (double)difference, 0.0, (double)difference);
            player.func_70091_d(MoverType.SELF, (double)(-(difference + difference)), 0.0, (double)(-(difference + difference)));
            player.func_70091_d(MoverType.SELF, (double)difference, 0.0, (double)difference);
        }
        player.field_70140_Q = distanceWalkedModified;
        player.field_82151_R = distanceWalkedOnStepModified;
        player.field_70123_F = collidedHorizontally || player.field_70123_F;
        player.field_70124_G = collidedVertically || player.field_70124_G;
        player.field_70122_E = onGround || player.field_70122_E;
        player.field_70132_H = collided || player.field_70132_H;
    }

    public EntityLivingBase getEntity(MorphState state) {
        return state.entInstance;
    }

    public boolean isMorphing() {
        return this.morphTime < Morph.config.morphTime && this.prevState != null;
    }

    public float getMorphProgress(float renderTick) {
        return MathHelper.func_76131_a((float)(((float)this.morphTime + renderTick) / (float)Morph.config.morphTime), (float)0.0f, (float)1.0f);
    }

    public float getMorphTransitionProgress(float renderTick) {
        return (float)Math.sin(Math.toRadians(MathHelper.func_76131_a((float)(((float)(this.morphTime - 10) + renderTick) / ((float)Morph.config.morphTime - 20.0f)), (float)0.0f, (float)1.0f) * 90.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getMorphSkinAlpha(float renderTick) {
        return (double)this.getMorphProgress(renderTick) < 0.5 ? (float)Math.pow(((float)this.morphTime + renderTick) / 10.0f, 2.0) : (float)Math.pow(1.0f - ((float)this.morphTime + renderTick - (float)(Morph.config.morphTime - 10)) / 10.0f, 2.0);
    }

    public void clean() {
        this.prevState = null;
        this.nextState.entInstance = null;
    }

    public void read(NBTTagCompound tag) {
        MorphVariant variant;
        if (tag.func_74764_b("prevStateVar")) {
            variant = new MorphVariant("");
            variant.read(tag.func_74775_l("prevStateVar"));
            this.prevState = new MorphState(variant);
        }
        variant = new MorphVariant("");
        variant.read(tag.func_74775_l("nextStateVar"));
        this.nextState = new MorphState(variant);
        this.morphTime = tag.func_74762_e("morphTime");
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        if (this.prevState != null) {
            tag.func_74782_a("prevStateVar", (NBTBase)this.prevState.currentVariant.write(new NBTTagCompound()));
        }
        tag.func_74782_a("nextStateVar", (NBTBase)this.nextState.currentVariant.write(new NBTTagCompound()));
        tag.func_74768_a("morphTime", this.morphTime);
        return tag;
    }
}

