/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.client.render;

import com.tattyseal.compactstorage.tileentity.TileEntityChest;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityChestRenderer
extends TileEntitySpecialRenderer<TileEntityChest> {
    private ModelChest model = new ModelChest();
    private static final ResourceLocation texture = new ResourceLocation("compactstorage", "textures/models/chest.png");

    public void render(TileEntityChest tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int color;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        EnumFacing direction = tile.direction;
        switch (direction) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        try {
            color = tile.color.brighter().getRGB();
        }
        catch (Exception exception) {
            color = Color.white.getRGB();
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        float f = tile.prevLidAngle + (tile.lidAngle - tile.prevLidAngle) * partialTicks;
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        this.model.field_78234_a.field_78795_f = -(f * 1.5707964f);
        this.model.func_78231_a();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (tile.getRetaining()) {
            ItemStack stack = new ItemStack(Items.field_151045_i, 1, 0);
            EntityItem item = new EntityItem(tile.func_145831_w(), 0.0, 0.0, 0.0, stack);
            item.field_70290_d = 0.0f;
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-1.1f, (float)0.01f);
            Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
        }
        GL11.glPopMatrix();
    }
}

