/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import forestry.api.core.Tabs;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.blocks.BlockApiculture;
import forestry.apiculture.blocks.BlockBeeHives;
import forestry.apiculture.blocks.BlockCandle;
import forestry.apiculture.blocks.BlockHoneyComb;
import forestry.apiculture.blocks.BlockStump;
import forestry.apiculture.blocks.BlockTypeApiculture;
import forestry.apiculture.blocks.BlockTypeApicultureTesr;
import forestry.apiculture.items.ItemBlockCandle;
import forestry.apiculture.items.ItemBlockHoneyComb;
import forestry.core.blocks.BlockBase;
import forestry.core.blocks.BlockRegistry;
import forestry.core.items.ItemBlockForestry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;

public class BlockRegistryApiculture
extends BlockRegistry {
    public final BlockApiculture apiary = new BlockApiculture(BlockTypeApiculture.APIARY);
    public final BlockApiculture beeHouse;
    public final BlockBase<BlockTypeApicultureTesr> beeChest;
    public final BlockBeeHives beehives;
    public final BlockCandle candle;
    public final BlockStump stump;
    public final BlockHoneyComb[] beeCombs;
    private final Map<BlockAlvearyType, BlockAlveary> alvearyBlockMap;

    public BlockRegistryApiculture() {
        this.registerBlock(this.apiary, new ItemBlockForestry<BlockApiculture>(this.apiary), "apiary");
        this.beeHouse = new BlockApiculture(BlockTypeApiculture.BEE_HOUSE);
        this.registerBlock(this.beeHouse, new ItemBlockForestry<BlockApiculture>(this.beeHouse), "bee_house");
        this.beeChest = new BlockBase<BlockTypeApicultureTesr>(BlockTypeApicultureTesr.APIARIST_CHEST, Material.field_151575_d);
        this.registerBlock(this.beeChest, new ItemBlockForestry<BlockBase<BlockTypeApicultureTesr>>(this.beeChest), "bee_chest");
        this.beeChest.func_149647_a(Tabs.tabApiculture);
        this.beeChest.setHarvestLevel("axe", 0);
        this.beehives = new BlockBeeHives();
        this.registerBlock(this.beehives, new ItemBlockForestry<BlockBeeHives>(this.beehives), "beehives");
        this.candle = new BlockCandle();
        this.registerBlock(this.candle, new ItemBlockCandle(this.candle), "candle");
        this.stump = new BlockStump();
        this.registerBlock(this.stump, new ItemBlockForestry<BlockStump>(this.stump), "stump");
        this.beeCombs = BlockHoneyComb.create();
        for (int i = 0; i < this.beeCombs.length; ++i) {
            BlockHoneyComb blockHoneyComb = this.beeCombs[i];
            this.registerBlock(blockHoneyComb, new ItemBlockHoneyComb(blockHoneyComb), "bee_combs_" + i);
        }
        this.alvearyBlockMap = BlockAlveary.create();
        for (BlockAlveary blockAlveary : this.alvearyBlockMap.values()) {
            this.registerBlock(blockAlveary, new ItemBlockForestry<BlockAlveary>(blockAlveary), "alveary." + (Object)((Object)blockAlveary.getAlvearyType()));
        }
    }

    public BlockAlveary getAlvearyBlock(BlockAlvearyType type) {
        BlockAlveary alvearyBlock = this.alvearyBlockMap.get((Object)type);
        return alvearyBlock;
    }

    public ItemStack getAlvearyBlockStack(BlockAlvearyType type) {
        BlockAlveary alvearyBlock = this.alvearyBlockMap.get((Object)type);
        return new ItemStack((Block)alvearyBlock);
    }
}

