/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import forestry.api.recipes.IFabricatorRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorRecipe
implements IFabricatorRecipe {
    private final ItemStack plan;
    private final FluidStack molten;
    private final NonNullList<NonNullList<ItemStack>> ingredients;
    private final NonNullList<String> oreDicts;
    private final ItemStack result;
    private final int width;
    private final int height;

    public FabricatorRecipe(ItemStack plan, FluidStack molten, ItemStack result, NonNullList<NonNullList<ItemStack>> ingredients, NonNullList<String> oreDicts, int width, int height) {
        Preconditions.checkNotNull((Object)plan);
        Preconditions.checkNotNull((Object)molten);
        Preconditions.checkNotNull((Object)result);
        Preconditions.checkArgument((!result.func_190926_b() ? 1 : 0) != 0);
        Preconditions.checkNotNull(ingredients);
        Preconditions.checkNotNull(oreDicts);
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0);
        this.plan = plan;
        this.molten = molten;
        this.result = result;
        this.ingredients = ingredients;
        this.oreDicts = oreDicts;
        this.width = width;
        this.height = height;
    }

    @Override
    public NonNullList<NonNullList<ItemStack>> getIngredients() {
        return this.ingredients;
    }

    @Override
    public NonNullList<String> getOreDicts() {
        return this.oreDicts;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ItemStack getPlan() {
        return this.plan;
    }

    @Override
    public FluidStack getLiquid() {
        return this.molten;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.result;
    }
}

