/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern.parameter;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum PatternParameterXZDir implements IStatementParameter
{
    WEST(EnumFacing.WEST),
    EAST(EnumFacing.EAST),
    NORTH(EnumFacing.NORTH),
    SOUTH(EnumFacing.SOUTH);

    private static final PatternParameterXZDir[] POSSIBLE_ORDER;
    private static final Map<EnumFacing, PatternParameterXZDir> map;
    public final EnumFacing dir;

    private PatternParameterXZDir(EnumFacing dir) {
        this.dir = dir;
    }

    public static PatternParameterXZDir get(EnumFacing face) {
        PatternParameterXZDir param = map.get(face);
        if (param == null) {
            throw new IllegalArgumentException("Can only accept horizontal EnumFacing's (was given " + face + ")");
        }
        return param;
    }

    public static PatternParameterXZDir readFromNbt(NBTTagCompound nbt) {
        EnumFacing dir;
        if (nbt.func_150297_b("dir", 99)) {
            int d = nbt.func_74771_c("dir") + 2;
            dir = EnumFacing.func_176731_b((int)d);
        } else {
            dir = EnumFacing.func_176731_b((int)nbt.func_74771_c("d"));
        }
        PatternParameterXZDir param = map.get(dir);
        if (param == null) {
            throw new IllegalStateException("Map lookup failed for " + dir);
        }
        return param;
    }

    @Override
    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74774_a("d", (byte)this.dir.func_176736_b());
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:fillerParameterXZDir";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        return BCBuildersSprites.PARAM_XZ_DIR.get(this.dir);
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("direction." + this.dir.func_176610_l());
    }

    @Override
    public PatternParameterXZDir onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return null;
    }

    @Override
    public IStatementParameter rotateLeft() {
        return PatternParameterXZDir.get(this.dir.func_176746_e());
    }

    @Override
    public IStatementParameter[] getPossible(IStatementContainer source) {
        return POSSIBLE_ORDER;
    }

    @Override
    public boolean isPossibleOrdered() {
        return true;
    }

    static {
        POSSIBLE_ORDER = new PatternParameterXZDir[]{null, null, NORTH, null, EAST, null, SOUTH, null, WEST};
        map = new EnumMap<EnumFacing, PatternParameterXZDir>(EnumFacing.class);
        for (PatternParameterXZDir param : PatternParameterXZDir.values()) {
            map.put(param.dir, param);
        }
    }
}

