/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.jei.energy.combustionengine;

import buildcraft.api.fuels.IFuel;
import buildcraft.api.fuels.IFuelManager;
import buildcraft.api.mj.MjAPI;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WrapperCombustionEngine
implements IRecipeWrapper {
    private final IFuel fuel;
    private final ImmutableList<FluidStack> in;
    private final IDrawableAnimated flame;

    WrapperCombustionEngine(IGuiHelper guiHelper, IFuel fuel) {
        this.fuel = fuel;
        this.in = ImmutableList.of((Object)new FluidStack(fuel.getFluid(), 1000));
        ResourceLocation furnaceBackgroundLocation = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        IDrawableStatic flameDrawable = guiHelper.createDrawable(furnaceBackgroundLocation, 176, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, fuel.getTotalBurningTime() / 10, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(FluidStack.class, this.in);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.flame.draw(minecraft, 2, 0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)24.0f, (float)8.0f, (float)0.0f);
        minecraft.field_71466_p.func_78276_b("Burns for " + this.fuel.getTotalBurningTime() / 20 + "s", 0, 0, Color.darkGray.getRGB());
        minecraft.field_71466_p.func_78276_b(" at " + MjAPI.formatMj(this.fuel.getPowerPerCycle()) + " MJ/t", 0, minecraft.field_71466_p.field_78288_b, Color.darkGray.getRGB());
        GlStateManager.func_179109_b((float)0.0f, (float)(minecraft.field_71466_p.field_78288_b * 2), (float)0.0f);
        GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)1.0);
        minecraft.field_71466_p.func_78276_b(" total " + MjAPI.formatMj(this.fuel.getPowerPerCycle() * (long)this.fuel.getTotalBurningTime()) + " MJ", 1, 2, Color.gray.getRGB());
        GlStateManager.func_179121_F();
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    public static class Dirty
    extends WrapperCombustionEngine {
        final IFuelManager.IDirtyFuel dirty;

        Dirty(IGuiHelper guiHelper, IFuelManager.IDirtyFuel fuel) {
            super(guiHelper, fuel);
            this.dirty = fuel;
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            super.getIngredients(ingredients);
            ingredients.setOutput(FluidStack.class, (Object)this.dirty.getResidue());
        }
    }
}

