/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.render.ISprite;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.parts.GuideImage;
import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.sprite.SpriteAtlas;
import buildcraft.lib.client.sprite.SpriteRaw;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class GuideImageFactory
implements GuidePartFactory {
    private final ISprite sprite;
    private final int srcWidth;
    private final int srcHeight;
    private final int width;
    private final int height;

    public GuideImageFactory(String location) {
        this(location, -1, -1);
    }

    public GuideImageFactory(String location, int width, int height) {
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite stitched = textureMap.func_110572_b(location);
        if (stitched != textureMap.func_174944_f()) {
            this.sprite = new SpriteAtlas(stitched);
            this.srcWidth = stitched.func_94211_a();
            this.srcHeight = stitched.func_94216_b();
        } else {
            int sh;
            int sw;
            ISprite s;
            ResourceLocation resLoc = new ResourceLocation(location);
            try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc);){
                PngSizeInfo size = PngSizeInfo.func_188532_a((IResource)resource);
                s = new SpriteRaw(resLoc, 0.0, 0.0, 1.0, 1.0);
                sw = size.field_188533_a;
                sh = size.field_188534_b;
            }
            catch (IOException io) {
                BCLog.logger.warn("[lib.guide.loader.image] Couldn't load image '" + resLoc + "' because " + io.getMessage());
                stitched = textureMap.func_174944_f();
                s = new SpriteAtlas(stitched);
                sw = stitched.func_94211_a();
                sh = stitched.func_94216_b();
            }
            this.sprite = s;
            this.srcWidth = sw;
            this.srcHeight = sh;
        }
        this.width = width <= 0 ? this.srcWidth : width;
        this.height = height <= 0 ? this.srcHeight : height;
    }

    @Override
    public GuideImage createNew(GuiGuide gui) {
        return new GuideImage(gui, this.sprite, this.srcWidth, this.srcHeight, this.width, this.height);
    }
}

