/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.model.ModelHolder;
import buildcraft.lib.client.model.ModelHolderRegistry;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.json.JsonTexture;
import buildcraft.lib.client.model.json.JsonVariableModel;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.ITickableNode;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class ModelHolderVariable
extends ModelHolder {
    public final Map<String, TextureAtlasSprite> customSprites = new HashMap<String, TextureAtlasSprite>();
    private final FunctionContext context;
    private JsonVariableModel rawModel;
    private boolean unseen = true;

    public ModelHolderVariable(String modelLocation, FunctionContext context) {
        super(modelLocation);
        this.context = context;
    }

    @Override
    public boolean hasBakedQuads() {
        return this.rawModel != null;
    }

    @Override
    protected void onTextureStitchPre(Set<ResourceLocation> toRegisterSprites) {
        this.rawModel = null;
        this.failReason = null;
        try {
            this.rawModel = JsonVariableModel.deserialize(this.modelLocation, this.context);
        }
        catch (JsonParseException jse) {
            this.rawModel = null;
            this.failReason = "The model had errors: " + jse.getMessage();
            BCLog.logger.warn("[lib.model.holder] Failed to load the model " + this.modelLocation + " because ", (Throwable)jse);
        }
        catch (IOException io) {
            this.rawModel = null;
            this.failReason = "The model did not exist in any resource pack: " + io.getMessage();
            BCLog.logger.warn("[lib.model.holder] Failed to load the model " + this.modelLocation + " because ", (Throwable)io);
        }
        if (this.rawModel != null) {
            this.rawModel.onTextureStitchPre(this.modelLocation, toRegisterSprites);
        }
    }

    @Override
    protected void onModelBake() {
    }

    private ModelUtil.TexturedFace lookupTexture(String lookup) {
        TextureAtlasSprite sprite;
        JsonTexture tex;
        JsonTexture texture = new JsonTexture(lookup);
        for (int attempts = 0; texture.location.startsWith("#") && attempts < 10 && (tex = this.rawModel.textures.get(texture.location)) != null; ++attempts) {
            texture = texture.inParent(tex);
        }
        lookup = texture.location;
        if (lookup.startsWith("~")) {
            sprite = this.customSprites.get(lookup.substring(1));
            if (sprite == null) {
                sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
        } else {
            sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(lookup);
        }
        ModelUtil.TexturedFace face = new ModelUtil.TexturedFace();
        face.sprite = sprite;
        face.faceData = texture.faceData;
        return face;
    }

    private void printNoModelWarning() {
        if (this.unseen) {
            this.unseen = false;
            String warnText = "[lib.model.holder] Tried to use the model " + this.modelLocation + " before it was baked!";
            if (ModelHolderRegistry.DEBUG) {
                BCLog.logger.warn(warnText, new Throwable());
            } else {
                BCLog.logger.warn(warnText);
            }
        }
    }

    @Nullable
    public JsonVariableModel getModel() {
        if (this.rawModel == null) {
            this.printNoModelWarning();
        }
        return this.rawModel;
    }

    public ITickableNode[] createTickableNodes() {
        if (this.rawModel == null) {
            this.printNoModelWarning();
            return new ITickableNode[0];
        }
        return this.rawModel.createTickableNodes();
    }

    public MutableQuad[] getCutoutQuads() {
        if (this.rawModel == null) {
            this.printNoModelWarning();
            return MutableQuad.EMPTY_ARRAY;
        }
        return this.rawModel.bakePart(this.rawModel.cutoutElements, this::lookupTexture);
    }

    public MutableQuad[] getTranslucentQuads() {
        if (this.rawModel == null) {
            this.printNoModelWarning();
            return MutableQuad.EMPTY_ARRAY;
        }
        return this.rawModel.bakePart(this.rawModel.translucentElements, this::lookupTexture);
    }
}

