/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.fluid;

import buildcraft.api.core.BCLog;
import buildcraft.lib.misc.SpriteUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class SpriteFluidFrozen
extends TextureAtlasSprite {
    public final ResourceLocation srcLocation;
    private int[][] data = null;

    public SpriteFluidFrozen(ResourceLocation srcLocation) {
        super("buildcraftlib:fluid_" + srcLocation.toString().replace(':', '_') + "_convert_frozen");
        this.srcLocation = srcLocation;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        location = SpriteUtil.transformLocation(this.srcLocation);
        TextureAtlasSprite src = Minecraft.func_71410_x().func_147117_R().getTextureExtry(this.srcLocation.toString());
        if (src == null) {
            BCLog.logger.warn("[lib.fluid] Failed to create a frozen sprite of " + this.srcLocation.toString() + " as the source sprite wasn't able to be loaded!");
            return true;
        }
        if (src.func_110970_k() <= 0) {
            if (src.hasCustomLoader(manager, location)) {
                src.load(manager, location, textureGetter);
            } else {
                try {
                    PngSizeInfo pngsizeinfo = PngSizeInfo.func_188532_a((IResource)manager.func_110536_a(location));
                    try (IResource resource = manager.func_110536_a(location);){
                        src.func_188538_a(pngsizeinfo, resource.func_110526_a("animation") != null);
                        src.func_188539_a(resource, Minecraft.func_71410_x().field_71474_y.field_151442_I + 1);
                    }
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
            }
        }
        if (src.func_110970_k() > 0) {
            int widthOld = src.func_94211_a();
            int heightOld = src.func_94216_b();
            this.field_130223_c = widthOld * 2;
            this.field_130224_d = heightOld * 2;
            int[][] srcData = src.func_147965_a(0);
            this.data = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
            for (int m = 0; m < this.data.length; ++m) {
                this.data[m] = new int[this.field_130223_c * this.field_130224_d / (m + 1) / (m + 1)];
            }
            int[] relData = srcData[0];
            if (relData.length < this.field_130223_c * this.field_130224_d / 4) {
                Arrays.fill(this.data[0], -256);
            } else {
                for (int x = 0; x < this.field_130223_c; ++x) {
                    int fx = x % widthOld * heightOld;
                    for (int y = 0; y < this.field_130224_d; ++y) {
                        int fy = y % heightOld;
                        this.data[0][x * this.field_130224_d + y] = relData[fx + fy];
                    }
                }
            }
        } else {
            BCLog.logger.warn("[lib.fluid] Failed to create a frozen sprite of " + src.func_94215_i() + " as the source sprite didn't have any frames!");
            return true;
        }
        return false;
    }

    public int func_110970_k() {
        return this.data == null ? 0 : 1;
    }

    public int[][] func_147965_a(int index) {
        return this.data;
    }

    public float func_94214_a(double u) {
        return super.func_94214_a(u / 2.0 + 4.0);
    }

    public float func_94207_b(double v) {
        return super.func_94207_b(v / 2.0 + 4.0);
    }
}

