/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.elem;

import buildcraft.lib.client.guide.font.MinecraftFont;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class GuiElementText
extends GuiElementSimple {
    public boolean dropShadow = false;
    public boolean foreground = false;
    public boolean centered = false;
    private final Supplier<String> text;
    private final IntSupplier colour;
    private final DoubleSupplier scale;

    public GuiElementText(BuildCraftGui gui, IGuiPosition parent, Supplier<String> text, IntSupplier colour) {
        this(gui, parent, text, colour, NodeConstantDouble.ONE);
    }

    public GuiElementText(BuildCraftGui gui, IGuiPosition parent, Supplier<String> text, IntSupplier colour, DoubleSupplier scale) {
        super(gui, GuiRectangle.ZERO.offset(parent));
        this.text = text;
        this.colour = colour;
        this.scale = scale;
    }

    public GuiElementText(BuildCraftGui gui, IGuiPosition parent, Supplier<String> text, int colour) {
        this(gui, parent, text, () -> colour);
    }

    public GuiElementText(BuildCraftGui gui, IGuiPosition parent, String text, int colour) {
        this(gui, parent, new NodeConstantObject<String>(String.class, text), () -> colour);
    }

    public GuiElementText setDropShadow(boolean value) {
        this.dropShadow = value;
        return this;
    }

    public GuiElementText setForeground(boolean value) {
        this.foreground = value;
        return this;
    }

    public GuiElementText setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    @Override
    public double getWidth() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        return fr.func_78256_a(this.text.get());
    }

    @Override
    public double getHeight() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        return fr.field_78288_b;
    }

    @Override
    public void drawBackground(float partialTicks) {
        if (!this.foreground) {
            this.draw();
        }
    }

    @Override
    public void drawForeground(float partialTicks) {
        if (this.foreground) {
            this.draw();
        }
    }

    private void draw() {
        MinecraftFont.INSTANCE.drawString(this.text.get(), (int)this.getX(), (int)this.getY(), this.colour.getAsInt(), this.dropShadow, this.centered, (float)this.scale.getAsDouble());
    }

    @Override
    public String getDebugInfo(List<String> info) {
        info.add("text = " + this.text);
        return super.getDebugInfo(info);
    }
}

