/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.registry;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum MigrationManager {
    INSTANCE;

    public static final boolean DEBUG;
    private final Map<String, Item> itemMigrations = new HashMap<String, Item>();
    private final Map<String, Block> blockMigrations = new HashMap<String, Block>();

    public void addItemMigration(Item to, String ... oldNames) {
        if (to == null) {
            return;
        }
        for (String old : oldNames) {
            String oldLowerCase = old.toLowerCase(Locale.ROOT);
            if (this.itemMigrations.containsKey(oldLowerCase)) {
                throw new IllegalArgumentException("Already registered item migration \"" + oldLowerCase + "\"!");
            }
            this.itemMigrations.put(oldLowerCase, to);
            if (!DEBUG) continue;
            BCLog.logger.info("[lib.migrate] Adding item migration from " + oldLowerCase + " to " + to.getRegistryName());
        }
    }

    public void addBlockMigration(Block to, String ... oldNames) {
        if (to == null) {
            return;
        }
        for (String old : oldNames) {
            String oldLowerCase = old.toLowerCase(Locale.ROOT);
            if (this.blockMigrations.containsKey(oldLowerCase)) {
                throw new IllegalArgumentException("Already registered block migration \"" + oldLowerCase + "\"!");
            }
            this.blockMigrations.put(oldLowerCase, to);
            if (!DEBUG) continue;
            BCLog.logger.info("[lib.migrate] Adding item migration from " + oldLowerCase + " to " + to.getRegistryName());
        }
    }

    @SubscribeEvent
    public void onMissingBlocks(RegistryEvent.MissingMappings<Block> missing) {
        MigrationManager.onMissingMappings(missing, this.blockMigrations);
    }

    @SubscribeEvent
    public void onMissingItems(RegistryEvent.MissingMappings<Item> missing) {
        MigrationManager.onMissingMappings(missing, this.itemMigrations);
    }

    private static <T extends IForgeRegistryEntry<T>> void onMissingMappings(RegistryEvent.MissingMappings<T> missing, Map<String, T> migrations) {
        ImmutableList all = missing.getAllMappings();
        if (all.isEmpty()) {
            return;
        }
        if (DEBUG) {
            BCLog.logger.info("[lib.migrate] Received missing mappings event for " + missing.getGenericType() + " with " + all.size() + " missing.");
        }
        for (RegistryEvent.MissingMappings.Mapping mapping : all) {
            IForgeRegistryEntry to;
            ResourceLocation loc = mapping.key;
            String domain = loc.func_110624_b();
            String path = loc.func_110623_a().toLowerCase(Locale.ROOT);
            if (DEBUG) {
                BCLog.logger.info("[lib.migrate]  - " + domain + ":" + path);
            }
            if (!domain.startsWith("buildcraft") || (to = (IForgeRegistryEntry)migrations.get(path)) == null) continue;
            mapping.remap(to);
            if (!DEBUG) continue;
            BCLog.logger.info("[lib.migrate]    -> " + to.getRegistryName());
        }
    }

    static {
        DEBUG = BCDebugging.shouldDebugLog("lib.migrate");
    }
}

