/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.zone;

import com.google.common.collect.ImmutableList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.vecmath.Point2i;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class ZoneChunk {
    public BitSet property;
    private boolean fullSet = false;

    public ZoneChunk() {
    }

    public ZoneChunk(ZoneChunk old) {
        if (old.property != null) {
            this.property = BitSet.valueOf(old.property.toLongArray());
        }
    }

    public boolean get(int xChunk, int zChunk) {
        return this.fullSet || this.property != null && this.property.get(xChunk + zChunk * 16);
    }

    public void set(int xChunk, int zChunk, boolean value) {
        if (value) {
            if (this.fullSet) {
                return;
            }
            if (this.property == null) {
                this.property = new BitSet(256);
            }
            this.property.set(xChunk + zChunk * 16, true);
            if (this.property.cardinality() >= 256) {
                this.property = null;
                this.fullSet = true;
            }
        } else {
            if (this.fullSet) {
                this.property = new BitSet(256);
                this.property.flip(0, 255);
                this.fullSet = false;
            } else if (this.property == null) {
                this.property = new BitSet(256);
            }
            this.property.set(xChunk + zChunk * 16, false);
        }
    }

    public List<Point2i> getAll() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int zChunk = 0; zChunk < 16; ++zChunk) {
            for (int xChunk = 0; xChunk < 16; ++xChunk) {
                if (!this.get(xChunk, zChunk)) continue;
                builder.add((Object)new Point2i(xChunk, zChunk));
            }
        }
        return builder.build();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("fullSet", this.fullSet);
        if (this.property != null) {
            nbt.func_74773_a("bits", this.property.toByteArray());
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.fullSet = nbt.func_74767_n("fullSet");
        if (nbt.func_74764_b("bits")) {
            this.property = BitSet.valueOf(nbt.func_74770_j("bits"));
        }
    }

    public BlockPos getRandomBlockPos(Random rand) {
        int z;
        int x;
        if (this.fullSet) {
            x = rand.nextInt(16);
            z = rand.nextInt(16);
        } else {
            int bitPosition = this.property.nextSetBit(0);
            for (int bitId = rand.nextInt(this.property.cardinality()); bitId > 0; --bitId) {
                bitPosition = this.property.nextSetBit(bitPosition + 1);
            }
            z = bitPosition / 16;
            x = bitPosition - 16 * z;
        }
        int y = rand.nextInt(255);
        return new BlockPos(x, y, z);
    }

    public boolean isEmpty() {
        return !this.fullSet && this.property.isEmpty();
    }

    public ZoneChunk readFromByteBuf(PacketBuffer buf) {
        short flags = buf.readUnsignedByte();
        if ((flags & 1) != 0) {
            this.property = BitSet.valueOf(buf.func_179251_a());
        }
        this.fullSet = (flags & 2) != 0;
        return this;
    }

    public void writeToByteBuf(PacketBuffer buf) {
        int flags = (this.fullSet ? 2 : 0) | (this.property != null ? 1 : 0);
        buf.writeByte(flags);
        if (this.property != null) {
            buf.func_179250_a(this.property.toByteArray());
        }
    }
}

