/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.client.model.plug;

import buildcraft.api.BCModules;
import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.silicon.client.model.key.KeyPlugFacade;
import buildcraft.silicon.client.model.plug.PlugBakerFacade;
import buildcraft.silicon.item.ItemPluggableFacade;
import buildcraft.silicon.plug.FacadeInstance;
import buildcraft.silicon.plug.FacadePhasedState;
import buildcraft.transport.BCTransportModels;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public enum ModelFacadeItem implements IBakedModel
{
    INSTANCE;

    private static final LoadingCache<KeyPlugFacade, IBakedModel> cache;

    public static void onModelBake() {
        cache.invalidateAll();
    }

    private static List<BakedQuad> bakeForKey(KeyPlugFacade key) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (MutableQuad quad : PlugBakerFacade.INSTANCE.bakeForKey(key)) {
            quads.add(quad.toBakedItem());
        }
        if (BCModules.TRANSPORT.isLoaded() && key.state.func_185913_b() && !key.isHollow) {
            for (MutableQuad quad : BCTransportModels.BLOCKER.getCutoutQuads()) {
                quads.add(quad.toBakedItem());
            }
        }
        return quads;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ModelItemSimple.TRANSFORM_PLUG_AS_BLOCK;
    }

    public ItemOverrideList func_188617_f() {
        return FacadeOverride.FACADE_OVERRIDE;
    }

    static {
        cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(CacheLoader.from(key -> new ModelItemSimple(ModelFacadeItem.bakeForKey(key), ModelItemSimple.TRANSFORM_PLUG_AS_BLOCK, false)));
    }

    public static class FacadeOverride
    extends ItemOverrideList {
        public static final FacadeOverride FACADE_OVERRIDE = new FacadeOverride();

        private FacadeOverride() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            FacadeInstance inst = ItemPluggableFacade.getStates(stack);
            FacadePhasedState state = inst.getCurrentStateForStack();
            return (IBakedModel)cache.getUnchecked((Object)new KeyPlugFacade(BlockRenderLayer.TRANSLUCENT, EnumFacing.WEST, state.stateInfo.state, inst.isHollow));
        }
    }
}

