/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.api.transport.pipe.EnumPipeColourType;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeFaceTex;
import buildcraft.lib.client.model.IModelCache;
import buildcraft.lib.client.model.ModelCache;
import buildcraft.transport.client.model.IPipeBaseModelGen;
import buildcraft.transport.client.model.PipeBaseModelGenStandard;
import buildcraft.transport.client.model.key.PipeModelKey;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.EnumDyeColor;

public class PipeModelCacheBase {
    public static IPipeBaseModelGen generator = PipeBaseModelGenStandard.INSTANCE;
    static final IModelCache<PipeBaseCutoutKey> cacheCutout = new ModelCache<PipeBaseCutoutKey>(PipeModelCacheBase::generateCutout);
    static final IModelCache<PipeBaseTranslucentKey> cacheTranslucent = new ModelCache<PipeBaseTranslucentKey>(PipeModelCacheBase::generateTranslucent);

    private static List<BakedQuad> generateCutout(PipeBaseCutoutKey key) {
        return generator.generateCutout(key);
    }

    private static List<BakedQuad> generateTranslucent(PipeBaseTranslucentKey key) {
        return generator.generateTranslucent(key);
    }

    public static final class PipeBaseTranslucentKey {
        public final EnumDyeColor colour;
        public final float[] connections;
        private final int hashCode;

        public PipeBaseTranslucentKey(PipeModelKey key) {
            this.colour = key.getColourType() == EnumPipeColourType.TRANSLUCENT ? key.colour : null;
            if (this.colour == null) {
                this.connections = null;
                this.hashCode = 0;
            } else {
                this.connections = key.connected;
                this.hashCode = Objects.hash(this.colour, Arrays.hashCode(this.connections));
            }
        }

        public boolean shouldRender() {
            return this.colour != null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PipeBaseTranslucentKey)) {
                return false;
            }
            PipeBaseTranslucentKey other = (PipeBaseTranslucentKey)obj;
            if (!this.shouldRender() && !other.shouldRender()) {
                return true;
            }
            if (!Arrays.equals(this.connections, other.connections)) {
                return false;
            }
            return this.colour == other.colour;
        }

        public String toString() {
            return "PipeBaseTranslucentKey [colour=" + this.colour + ", connections=" + Arrays.toString(this.connections) + "]";
        }
    }

    public static final class PipeBaseCutoutKey {
        public final PipeDefinition definition;
        public final PipeFaceTex centerSprite;
        public final PipeFaceTex[] sideSprites;
        public final float[] connections;
        public final EnumDyeColor colour;
        public final EnumPipeColourType colourType;
        private final int hashCode;

        public PipeBaseCutoutKey(PipeModelKey key) {
            this.definition = key.definition;
            this.centerSprite = key.center;
            this.sideSprites = key.sides;
            this.connections = key.connected;
            EnumPipeColourType defColourType = key.getColourType();
            if (key.colour != null && PipeBaseCutoutKey.canBakeCutoutColour(defColourType)) {
                this.colour = key.colour;
                this.colourType = defColourType;
            } else {
                this.colour = null;
                this.colourType = null;
            }
            this.hashCode = Objects.hash(new Object[]{System.identityHashCode(this.definition), this.centerSprite, Arrays.hashCode(this.sideSprites), Arrays.hashCode(this.connections), this.colour, this.colourType});
        }

        private static boolean canBakeCutoutColour(EnumPipeColourType type) {
            return type == EnumPipeColourType.BORDER_OUTER || type == EnumPipeColourType.BORDER_INNER;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PipeBaseCutoutKey other = (PipeBaseCutoutKey)obj;
            if (this.definition != other.definition) {
                return false;
            }
            if (this.centerSprite != other.centerSprite) {
                return false;
            }
            if (this.colour != other.colour) {
                return false;
            }
            if (this.colourType != other.colourType) {
                return false;
            }
            if (!Arrays.equals(this.connections, other.connections)) {
                return false;
            }
            return Arrays.equals(this.sideSprites, other.sideSprites);
        }

        public String toString() {
            return "PipeBaseCutoutKey [center=" + this.centerSprite + ", sides=" + Arrays.toString(this.sideSprites) + ", connections=" + Arrays.toString(this.connections) + "]";
        }
    }
}

