/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution;

import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.registry.ModFeatureParser;
import com.brandon3055.draconicevolution.CommonProxy;
import com.brandon3055.draconicevolution.GuiHandler;
import com.brandon3055.draconicevolution.OreHandler;
import com.brandon3055.draconicevolution.client.creativetab.DETab;
import com.brandon3055.draconicevolution.command.CommandReloadFusion;
import com.brandon3055.draconicevolution.command.CommandUpgrade;
import com.brandon3055.draconicevolution.lib.OreDoublingRegistry;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.brandon3055.draconicevolution.world.DEWorldGenHandler;
import java.util.Locale;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

@Mod(modid="draconicevolution", name="Draconic Evolution", version="2.3.24", guiFactory="com.brandon3055.draconicevolution.DEGuiFactory", dependencies="before:thermalexpansion;after:thermalfoundation;required-after:brandonscore@[2.4.12,);", acceptedMinecraftVersions="[1.12.2]")
public class DraconicEvolution {
    public static final String MODID = "draconicevolution";
    public static final String MODNAME = "Draconic Evolution";
    public static final String VERSION = "2.3.24";
    public static final String MOD_PREFIX = "draconicevolution".toLowerCase(Locale.ENGLISH) + ":";
    public static final String PROXY_CLIENT = "com.brandon3055.draconicevolution.client.ClientProxy";
    public static final String PROXY_SERVER = "com.brandon3055.draconicevolution.CommonProxy";
    public static final String DEPENDENCIES = "before:thermalexpansion;after:thermalfoundation;required-after:brandonscore@[2.4.12,);";
    public static final String GUI_FACTORY = "com.brandon3055.draconicevolution.DEGuiFactory";
    public static final String networkChannelName = "DEvolutionNC";
    public static CreativeTabs tabToolsWeapons = new DETab(CreativeTabs.getNextID(), "draconicevolution", "toolsAndWeapons", 0);
    public static CreativeTabs tabBlocksItems = new DETab(CreativeTabs.getNextID(), "draconicevolution", "blocksAndItems", 1);
    public static SimpleNetworkWrapper network;
    @Mod.Instance(value="draconicevolution")
    public static DraconicEvolution instance;
    @SidedProxy(clientSide="com.brandon3055.draconicevolution.client.ClientProxy", serverSide="com.brandon3055.draconicevolution.CommonProxy")
    public static CommonProxy proxy;

    public DraconicEvolution() {
        LogHelper.info("Hello Minecraft!!!");
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandUpgrade());
        event.registerServerCommand((ICommand)new CommandReloadFusion());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModFeatureParser.registerModFeatures((String)MODID);
        proxy.preInit(event);
        proxy.registerParticles();
        OreHandler.initialize();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        DEWorldGenHandler.initialize();
        GuiHandler.initialize();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void processMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            LogHelper.info(m.key);
            if (!m.isItemStackMessage() || !m.key.startsWith("addChestRecipe:")) continue;
            String s = m.key.replace("addChestRecipe:", "");
            StackReference reference = StackReference.fromString((String)s);
            if (reference == null) {
                LogHelper.error("IMC error. Mod: " + m.getSender() + " tried to register a smelting override but the specified input stack was invalid! Input: " + s);
                continue;
            }
            ItemStack stack = reference.createStack();
            if (stack.func_190926_b()) {
                LogHelper.error("IMC error. Mod: " + m.getSender() + " tried to register a smelting override but the specified input stack could not be found! Input: " + s);
                continue;
            }
            OreDoublingRegistry.registerResult(stack, m.getItemStackValue());
            LogHelper.info("Added Chest recipe override: " + stack + " -> " + m.getItemStackValue());
        }
    }
}

