/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class PacketCompressible
implements IMessage {
    public abstract void writeBytes(ByteBuf var1);

    public abstract void readBytes(ByteBuf var1);

    public void fromBytes(ByteBuf buf) {
        boolean isCompressed = buf.readBoolean();
        if (!isCompressed) {
            this.readBytes(buf);
            return;
        }
        Inflater inflater = new Inflater();
        try {
            int rawSize = buf.readInt();
            byte[] compressedBytes = new byte[buf.readableBytes()];
            buf.readBytes(compressedBytes);
            buf = Unpooled.buffer();
            inflater.setInput(compressedBytes);
            byte[] rawBytes = new byte[rawSize];
            inflater.inflate(rawBytes);
            buf.clear();
            buf.writeBytes(rawBytes);
            buf.readerIndex(0);
            this.readBytes(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EncoderException((Throwable)e);
        }
        finally {
            inflater.end();
        }
    }

    public void toBytes(ByteBuf buf) {
        Deflater deflater = new Deflater();
        try {
            buf.writeBoolean(false);
            this.writeBytes(buf);
            buf.readerIndex(2);
            int rawSize = buf.readableBytes();
            deflater.setInput(buf.array(), buf.readerIndex(), rawSize);
            deflater.finish();
            byte[] cBytes = new byte[rawSize];
            int cSize = deflater.deflate(cBytes);
            if (cSize >= rawSize - 6 || !deflater.finished()) {
                return;
            }
            buf.readerIndex(0);
            byte packetId = buf.readByte();
            byte[] out = new byte[cSize];
            System.arraycopy(cBytes, 0, out, 0, out.length);
            buf.clear();
            buf.writeByte((int)packetId);
            buf.writeBoolean(true);
            buf.writeInt(rawSize);
            buf.writeBytes(out);
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            buf.readerIndex(0);
            deflater.end();
        }
    }
}

