/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.handlers.DislocatorLinkHandler;
import com.brandon3055.draconicevolution.utils.LogHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDislocatorUpdateRequest
implements IMessage {
    private String linkID;
    private DislocatorLinkHandler.LinkData data;
    private boolean isRequest;

    public PacketDislocatorUpdateRequest() {
    }

    public PacketDislocatorUpdateRequest(String linkID) {
        this.linkID = linkID;
        this.isRequest = true;
    }

    public PacketDislocatorUpdateRequest(String linkID, DislocatorLinkHandler.LinkData data) {
        this.linkID = linkID;
        this.data = data;
        this.isRequest = false;
    }

    public void fromBytes(ByteBuf buf) {
        this.isRequest = buf.readBoolean();
        this.linkID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (!this.isRequest) {
            NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
            this.data = compound == null || compound.func_82582_d() ? null : new DislocatorLinkHandler.LinkData(null).fromNBT(compound);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isRequest);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.linkID);
        if (!this.isRequest) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)(this.data == null ? new NBTTagCompound() : this.data.toNBT(new NBTTagCompound())));
        }
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketDislocatorUpdateRequest, IMessage> {
        public IMessage handleMessage(PacketDislocatorUpdateRequest message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(player.field_70170_p);
                DislocatorLinkHandler.LinkData reply = null;
                if (data != null && DislocatorLinkHandler.getLinkPos(player.field_70170_p, message.linkID) != null) {
                    reply = data.linkDataMap.get(message.linkID);
                    LogHelper.dev("Reply: " + reply.isPlayer);
                }
                DraconicEvolution.network.sendTo((IMessage)new PacketDislocatorUpdateRequest(message.linkID, reply), player);
            } else {
                DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(BrandonsCore.proxy.getClientWorld());
                if (data != null) {
                    if (message.data == null) {
                        data.linkDataMap.remove(message.linkID);
                    } else {
                        data.linkDataMap.put(message.linkID, message.data);
                    }
                }
            }
            return null;
        }
    }
}

