/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.lib.IEntityFilterItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemIDCard
extends ItemBase
implements IEntityFilterItem {
    public ItemIDCard() {
        super("idcard");
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        NBTTagCompound compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("name")) {
            displayName = displayName + " (" + compound.func_74779_i("name") + ")";
        }
        return displayName;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound compound;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("name")) {
            String name = compound.func_74779_i("name");
            tooltip.add(name);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack me = playerIn.func_184586_b(handIn);
        GameProfile playerProfile = playerIn.func_146103_bH();
        if (playerProfile != null) {
            UUID uuid = playerProfile.getId();
            String name = playerProfile.getName();
            if (!me.func_77942_o()) {
                me.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound compound = me.func_77978_p();
            compound.func_74778_a("uuid", uuid.toString());
            compound.func_74778_a("name", name != null ? name : "Anonymous");
            return new ActionResult(EnumActionResult.SUCCESS, (Object)me);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public boolean apply(ItemStack me, Entity entity) {
        NBTTagCompound compound;
        if (me.func_77942_o() && (compound = me.func_77978_p()).func_74764_b("uuid")) {
            UUID uuid = UUID.fromString(compound.func_74779_i("uuid"));
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                return uuid.equals(player.func_146103_bH().getId());
            }
        }
        return entity instanceof EntityPlayer;
    }

    public static UUID getUUID(ItemStack card) {
        NBTTagCompound compound;
        if (card.func_77942_o() && (compound = card.func_77978_p()).func_74764_b("uuid")) {
            return UUID.fromString(compound.func_74779_i("uuid"));
        }
        return null;
    }
}

