/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.tiles;

import al132.alchemistry.ConfigHandler;
import al132.alchemistry.recipes.EvaporatorRecipe;
import al132.alchemistry.recipes.ModRecipes;
import al132.alchemistry.tiles.TileBase;
import al132.alib.tiles.ALTileStackHandler;
import al132.alib.tiles.IFluidTile;
import al132.alib.tiles.IGuiTile;
import al132.alib.tiles.IItemTile;
import al132.alib.utils.extensions.IItemHandlerKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\f\u00a8\u0006$"}, d2={"Lal132/alchemistry/tiles/TileEvaporator;", "Lal132/alchemistry/tiles/TileBase;", "Lal132/alib/tiles/IGuiTile;", "Lnet/minecraft/util/ITickable;", "Lal132/alib/tiles/IItemTile;", "Lal132/alib/tiles/IFluidTile;", "()V", "calculatedProcessingTime", "", "getCalculatedProcessingTime", "()I", "setCalculatedProcessingTime", "(I)V", "currentRecipe", "Lal132/alchemistry/recipes/EvaporatorRecipe;", "fluidTanks", "Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "getFluidTanks", "()Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "inputTank", "Lnet/minecraftforge/fluids/FluidTank;", "getInputTank", "()Lnet/minecraftforge/fluids/FluidTank;", "progressTicks", "getProgressTicks", "setProgressTicks", "calculateProcessingTime", "canProcess", "", "process", "", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "update", "writeToNBT", "alchemistry"})
public final class TileEvaporator
extends TileBase
implements IGuiTile,
ITickable,
IItemTile,
IFluidTile {
    @NotNull
    private final FluidTank inputTank;
    private EvaporatorRecipe currentRecipe;
    private int progressTicks;
    private int calculatedProcessingTime;

    @NotNull
    public final FluidTank getInputTank() {
        return this.inputTank;
    }

    public final int getProgressTicks() {
        return this.progressTicks;
    }

    public final void setProgressTicks(int n) {
        this.progressTicks = n;
    }

    public final int getCalculatedProcessingTime() {
        return this.calculatedProcessingTime;
    }

    public final void setCalculatedProcessingTime(int n) {
        this.calculatedProcessingTime = n;
    }

    /*
     * WARNING - void declaration
     */
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.inputTank.getFluidAmount() > 0) {
            Object v1;
            block3: {
                void $receiver$iv;
                Iterable iterable = ModRecipes.INSTANCE.getEvaporatorRecipes();
                TileEvaporator tileEvaporator = this;
                for (Object element$iv : $receiver$iv) {
                    EvaporatorRecipe it = (EvaporatorRecipe)element$iv;
                    FluidStack fluidStack = this.inputTank.getFluid();
                    if (!(fluidStack != null ? fluidStack.containsFluid(it.getInput()) : false)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            Object var8_6 = v1;
            tileEvaporator.currentRecipe = var8_6;
            if (this.canProcess()) {
                this.process();
            }
            this.markDirtyGUIEvery(5);
        }
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        NBTTagCompound inputTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankNBT);
        compound.func_74782_a("InputTankNBT", (NBTBase)inputTankNBT);
        compound.func_74768_a("ProgressTicks", this.progressTicks);
        return compound;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTankNBT"));
        this.progressTicks = compound.func_74762_e("ProgressTicks");
    }

    @Nullable
    public FluidHandlerConcatenate getFluidTanks() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{(IFluidHandler)this.inputTank});
    }

    public final boolean canProcess() {
        if (this.currentRecipe != null) {
            EvaporatorRecipe evaporatorRecipe = this.currentRecipe;
            if (evaporatorRecipe == null) {
                Intrinsics.throwNpe();
            }
            ItemStack recipeOutput = evaporatorRecipe.getOutput();
            int n = this.inputTank.getFluidAmount();
            EvaporatorRecipe evaporatorRecipe2 = this.currentRecipe;
            if (evaporatorRecipe2 == null) {
                Intrinsics.throwNpe();
            }
            return n >= evaporatorRecipe2.getInput().amount && IItemHandlerKt.get((IItemHandler)((IItemHandler)this.getOutput()), (int)0).func_190916_E() + recipeOutput.func_190916_E() <= recipeOutput.func_77976_d();
        }
        return false;
    }

    public final int calculateProcessingTime() {
        Integer n = ConfigHandler.INSTANCE.getEvaporatorProcessingTicks();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        int temp = n;
        if (!BiomeDictionary.hasType((Biome)this.field_145850_b.getBiomeForCoordsBody(this.field_174879_c), (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            Integer n2 = ConfigHandler.INSTANCE.getEvaporatorProcessingTicks();
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            temp += (int)((double)n2.intValue() * 0.5);
        }
        return temp;
    }

    public final void process() {
        if (this.progressTicks % 5 == 0) {
            this.calculatedProcessingTime = this.calculateProcessingTime();
        }
        if (this.progressTicks < this.calculatedProcessingTime) {
            int n = this.progressTicks;
            this.progressTicks = n + 1;
        } else {
            this.progressTicks = 0;
            EvaporatorRecipe evaporatorRecipe = this.currentRecipe;
            if (evaporatorRecipe == null) {
                Intrinsics.throwNpe();
            }
            this.inputTank.drainInternal(evaporatorRecipe.getInput().amount, true);
            ALTileStackHandler aLTileStackHandler = this.getOutput();
            EvaporatorRecipe evaporatorRecipe2 = this.currentRecipe;
            if (evaporatorRecipe2 == null) {
                Intrinsics.throwNpe();
            }
            ItemStack itemStack = evaporatorRecipe2.getOutput().func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"currentRecipe!!.output.copy()");
            aLTileStackHandler.setOrIncrement(0, itemStack);
        }
    }

    public TileEvaporator() {
        this.initInventoryCapability(0, 1);
        this.inputTank = new FluidTank(10000){

            public boolean canFillFluidType(@Nullable FluidStack fluid) {
                boolean bl;
                block3: {
                    Iterable $receiver$iv = ModRecipes.INSTANCE.getEvaporatorRecipes();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            EvaporatorRecipe it = (EvaporatorRecipe)element$iv;
                            FluidStack fluidStack = fluid;
                            if (!Intrinsics.areEqual((Object)it.getInput().getFluid(), (Object)(fluidStack != null ? fluidStack.getFluid() : null))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            protected void onContentsChanged() {
                super.onContentsChanged();
                this.markDirtyClient();
            }
        };
        this.inputTank.setTileEntity((TileEntity)this);
        this.inputTank.setCanFill(true);
        this.inputTank.setCanDrain(false);
    }

    public int getGuiHeight() {
        return IGuiTile.DefaultImpls.getGuiHeight((IGuiTile)this);
    }

    public int getGuiWidth() {
        return IGuiTile.DefaultImpls.getGuiWidth((IGuiTile)this);
    }
}

