/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client.render;

import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import worldcontrolteam.worldcontrol.blocks.BlockBasicRotate;
import worldcontrolteam.worldcontrol.client.render.RenderInfoPanel;
import worldcontrolteam.worldcontrol.tileentity.TileEntityBaseReactorHeatMonitor;

public class RenderHeatMonitor
extends TileEntitySpecialRenderer<TileEntityBaseReactorHeatMonitor> {
    private static final String TEXTURE_FILE = "worldcontrol:textures/blocks/remoteheatmonitor/scale.png";
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("worldcontrol:textures/blocks/remoteheatmonitor/scale.png");

    public void render(TileEntityBaseReactorHeatMonitor te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179123_a();
        int i = this.func_178459_a().func_175626_b(te.func_174877_v().func_177972_a((EnumFacing)this.func_178459_a().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockBasicRotate.FACING)), 0);
        int i1 = i % 65536;
        int j1 = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)i1, (float)j1);
        GlStateManager.func_179140_f();
        if (te.getRenderType().equals("half_block")) {
            this.renderNumberOnBlock(te.getThreshhold(), (EnumFacing)this.func_178459_a().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockBasicRotate.FACING), 0.0f, x, y, z);
        } else if (te.getRenderType().equals("full_block")) {
            this.renderNumberOnBlock(te.getThreshhold(), (EnumFacing)this.func_178459_a().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockBasicRotate.FACING), 0.58f, x, y, z);
            this.drawHeatMap(te, (EnumFacing)this.func_178459_a().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockBasicRotate.FACING), x, y, z);
        }
        GlStateManager.func_179099_b();
    }

    private void renderNumberOnBlock(int number, EnumFacing facing, float translationOffset, double x, double y, double z) {
        int threshold = number;
        GlStateManager.func_179094_E();
        short side = (short)facing.func_176734_d().func_176745_a();
        float var12 = 0.014f;
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        switch (side) {
            case 0: {
                break;
            }
            case 1: {
                GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 3: {
                GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 4: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 5: {
                GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179109_b((float)0.5f, (float)(0.4375f + translationOffset), (float)0.6875f);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)var12, (float)(-var12), (float)var12);
        GlStateManager.func_179136_a((float)-10.0f, (float)-10.0f);
        GlStateManager.func_179088_q();
        this.func_147498_b().func_78276_b(String.valueOf(threshold), -this.func_147498_b().func_78256_a(String.valueOf(threshold)) / 2, -this.func_147498_b().field_78288_b, 0);
        GlStateManager.func_179113_r();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void drawHeatMap(TileEntityBaseReactorHeatMonitor baseReactorHeatMonitor, EnumFacing facing, double x, double y, double z) {
        GlStateManager.func_179094_E();
        RenderInfoPanel.setupFaceTransforms(x, y, z, facing);
        this.func_147499_a(TEXTURE_LOCATION);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder b = t.func_178180_c();
        int amt = (int)(64.0 * MathHelper.func_151237_a((double)(400.0 / (double)baseReactorHeatMonitor.getThreshhold()), (double)0.0, (double)1.0));
        double other_amt = (double)amt / 64.0;
        b.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        b.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(1, 1, 1, 1).func_181675_d();
        b.func_181662_b((double)amt, 0.0, 0.0).func_187315_a(other_amt, 0.0).func_181669_b(1, 1, 1, 1).func_181675_d();
        b.func_181662_b((double)amt, 64.0, 0.0).func_187315_a(other_amt, 1.0).func_181669_b(1, 1, 1, 1).func_181675_d();
        b.func_181662_b(0.0, 64.0, 0.0).func_187315_a(0.0, 1.0).func_181669_b(1, 1, 1, 1).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

