/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.crossmod.extremereactors.reactormonitor;

import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import it.zerono.mods.zerocore.api.multiblock.validation.IMultiblockValidator;
import net.minecraft.nbt.NBTTagCompound;

public class TileReactorMonitor
extends TileEntityReactorPartBase
implements ITickableMultiblockPart {
    private boolean isReactorOn;
    private float energyStored;
    private float energyGen;
    private float EstoredPer;
    private int temp;
    private boolean shouldBlockCache;
    private int meta;

    public TileReactorMonitor() {
        this.meta = 0;
        this.shouldBlockCache = false;
    }

    public TileReactorMonitor(int meta) {
        this.shouldBlockCache = false;
        this.meta = meta;
    }

    public boolean isGoodForSides(IMultiblockValidator validatorCallback) {
        return true;
    }

    public boolean isGoodForTop(IMultiblockValidator validatorCallback) {
        return true;
    }

    public boolean isGoodForBottom(IMultiblockValidator validatorCallback) {
        return true;
    }

    public void onMultiblockServerTick() {
        if (this.shouldBlockCache) {
            this.isReactorOn = this.getReactorController().getActive();
            this.energyStored = this.getReactorController().getEnergyStored();
            this.energyGen = this.getReactorController().getEnergyGeneratedLastTick();
            this.EstoredPer = this.getReactorController().getEnergyStoredPercentage();
            this.temp = (int)this.getReactorController().getFuelHeat();
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.shouldBlockCache = tag.func_74767_n("cache");
        this.meta = tag.func_74762_e("meta");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("cache", this.shouldBlockCache);
        tag.func_74768_a("meta", this.meta);
        return tag;
    }

    public float getEnergyStored() {
        return this.energyStored;
    }

    public float getEnergyGenerated() {
        return this.energyGen;
    }

    public boolean isReactorOnline() {
        return this.isReactorOn;
    }

    public void startFetching() {
        this.shouldBlockCache = true;
    }

    public float getEnergyOutPercent() {
        return this.EstoredPer;
    }

    public int getTemp() {
        return this.temp;
    }

    public MultiblockReactor getReactor() {
        return this.getReactorController();
    }

    public PartTier getPartTier() {
        return PartTier.fromMeta((int)this.meta);
    }
}

