/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.crossmod.industrialcraft2.blocks;

import ic2.api.energy.prefab.BasicSink;
import ic2.api.item.IElectricItem;
import ic2.api.reactor.IReactor;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import worldcontrolteam.worldcontrol.crossmod.industrialcraft2.IC2Module;
import worldcontrolteam.worldcontrol.crossmod.industrialcraft2.ReactorUtils;
import worldcontrolteam.worldcontrol.crossmod.industrialcraft2.items.IC2ReactorCard;
import worldcontrolteam.worldcontrol.inventory.ISlotItemFilter;
import worldcontrolteam.worldcontrol.items.ItemUpgrade;
import worldcontrolteam.worldcontrol.tileentity.TileEntityBaseReactorHeatMonitor;
import worldcontrolteam.worldcontrol.utils.NBTUtils;
import worldcontrolteam.worldcontrol.utils.WCConfig;

public class TileEntityIC2RemoteReactorMonitor
extends TileEntityBaseReactorHeatMonitor
implements IItemHandler,
IItemHandlerModifiable,
ISlotItemFilter {
    private NonNullList<ItemStack> itemStack = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private static final double MIN_RANGE = 20.0;
    private static final double ADDITIONAL_RANGE = 2.75;
    private static final int BASE_STORAGE = 600;
    private static final int STORAGE_PER_UPGRADE = 10000;
    private BasicSink energySink = new BasicSink((TileEntity)this, 600.0, 1);

    public void onLoad() {
        this.energySink.onLoad();
    }

    public void func_145843_s() {
        this.energySink.invalidate();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.energySink.onChunkUnload();
    }

    @Override
    public int getCurrentHeat() {
        BlockPos ref = this.getReferenceBlock();
        if (ref != null) {
            IReactor reactor = ReactorUtils.getReactorAt(this.field_145850_b, ref);
            if (reactor != null) {
                return reactor.getHeat();
            }
            return -1;
        }
        return -2;
    }

    @Override
    public boolean isOverHeated() {
        if (this.energySink.useEnergy((double)WCConfig.remoteMonitorPowerUseIC2)) {
            return super.isOverHeated();
        }
        return false;
    }

    @Override
    public boolean isConnectionValid() {
        ItemStack card;
        if (this.itemStack.get(0) != ItemStack.field_190927_a && ((ItemStack)this.itemStack.get(0)).func_77973_b() instanceof IC2ReactorCard && (card = (ItemStack)this.itemStack.get(0)).func_77942_o()) {
            BlockPos pos = NBTUtils.getBlockPos(card.func_77978_p());
            double distance = this.func_174877_v().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (distance <= (double)(((ItemStack)this.itemStack.get(1)).func_190916_E() - 1) * 2.75 + 20.0) {
                this.setReferenceBlock(pos);
                return true;
            }
        }
        return false;
    }

    public int getSlots() {
        return this.itemStack.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.itemStack.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (slot == -1) {
            return stack;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.itemStack.set(slot, (Object)copy);
                }
                return stack;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.itemStack.set(slot, (Object)copy);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.itemStack.set(slot, (Object)stack.func_77979_a(m));
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.itemStack.set(slot, (Object)stack);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stack.func_190916_E() < amount) {
                return stack.func_77946_l();
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stack.func_190916_E(), amount);
        ItemStack ret = this.decrStackSize(slot, m);
        this.func_70296_d();
        return ret;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != ItemStack.field_190927_a) {
            if (stack.func_190916_E() > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.itemStack.set(slot, (Object)ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.itemStack.set(slot, (Object)stack);
        if (stack != ItemStack.field_190927_a && stack.func_190916_E() > this.getSlotLimit(slot)) {
            stack.func_190920_e(this.getSlotLimit(slot));
        }
    }

    public double getEnergy() {
        return this.energySink.getEnergyStored();
    }

    public void setEnergy(int energyIn) {
        this.energySink.setEnergyStored((double)energyIn);
    }

    public double getMaxStorage() {
        return this.energySink.getCapacity();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energySink.readFromNBT(nbttagcompound);
        for (int i = 0; i < this.itemStack.size(); ++i) {
            NBTTagCompound tag = nbttagcompound.func_74775_l("stack" + i);
            ItemStack stack = new ItemStack(tag);
            this.itemStack.set(i, (Object)stack);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.energySink.writeToNBT(nbttagcompound);
        for (int i = 0; i < this.itemStack.size(); ++i) {
            ItemStack stack = (ItemStack)this.itemStack.get(i);
            NBTTagCompound tag = stack.func_77955_b(new NBTTagCompound());
            nbttagcompound.func_74782_a("stack" + i, (NBTBase)tag);
        }
        return nbttagcompound;
    }

    @Override
    public Block getBlock() {
        return IC2Module.REMOTE_THERMO_MONITOR;
    }

    @Override
    public String getRenderType() {
        return "full_block";
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack itemstack) {
        switch (slotIndex) {
            case 1: {
                IElectricItem item;
                if (Item.func_150891_b((Item)itemstack.func_77973_b()) == Item.func_150891_b((Item)IC2Module.suBattery.func_77973_b())) {
                    return true;
                }
                return itemstack.func_77973_b() instanceof IElectricItem && (item = (IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) && item.getTier(itemstack) <= this.energySink.getSinkTier();
            }
            case 0: {
                return itemstack.func_77973_b() instanceof IC2ReactorCard;
            }
        }
        return itemstack.func_77969_a(IC2Module.transformerUpgrade) || itemstack.func_77969_a(IC2Module.energyUpgrade) || itemstack.func_77973_b() instanceof ItemUpgrade && itemstack.func_77952_i() == 0;
    }
}

