/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import worldcontrolteam.worldcontrol.blocks.BlockAdvancedInfoPanel;
import worldcontrolteam.worldcontrol.blocks.BlockHowlerAlarm;
import worldcontrolteam.worldcontrol.blocks.BlockIndustrialAlarm;
import worldcontrolteam.worldcontrol.blocks.BlockInfoPanel;
import worldcontrolteam.worldcontrol.blocks.BlockInfoPanelExtender;
import worldcontrolteam.worldcontrol.init.IItemBlockFactory;
import worldcontrolteam.worldcontrol.items.ItemCardTime;
import worldcontrolteam.worldcontrol.items.ItemFluidCard;
import worldcontrolteam.worldcontrol.items.ItemFluidKit;
import worldcontrolteam.worldcontrol.items.ItemForgeEnergyCard;
import worldcontrolteam.worldcontrol.items.ItemForgeEnergyKit;
import worldcontrolteam.worldcontrol.items.ItemImageCard;
import worldcontrolteam.worldcontrol.items.ItemRemotePanel;
import worldcontrolteam.worldcontrol.items.ItemThermometer;
import worldcontrolteam.worldcontrol.items.ItemUpgrade;
import worldcontrolteam.worldcontrol.tileentity.TileEntityHowlerAlarm;
import worldcontrolteam.worldcontrol.tileentity.TileEntityInfoPanel;
import worldcontrolteam.worldcontrol.tileentity.TileEntityInfoPanelExtender;

@Mod.EventBusSubscriber
public class WCContent {
    public static List<Block> BLOCKS = new ArrayList<Block>();
    public static List<Item> ITEMS = new ArrayList<Item>();
    @GameRegistry.ObjectHolder(value="worldcontrol:remote_panel")
    public static Item REMOTE_PANEL;
    @GameRegistry.ObjectHolder(value="worldcontrol:fluid_card")
    public static Item FLUID_CARD;
    @GameRegistry.ObjectHolder(value="worldcontrol:forge_energy_card")
    public static Item FORGE_ENERGY_CARD;
    @GameRegistry.ObjectHolder(value="worldcontrol:upgrade_cards")
    public static Item UPGRADE;
    @GameRegistry.ObjectHolder(value="worldcontrol:howler_alarm")
    public static Block HOWLER_ALARM;
    @GameRegistry.ObjectHolder(value="worldcontrol:info_panel")
    public static Block INFO_PANEL;
    @GameRegistry.ObjectHolder(value="worldcontrol:info_panel_advanced")
    public static Block INFO_PANEL_ADVANCED;
    @GameRegistry.ObjectHolder(value="worldcontrol:info_panel_extender")
    public static Block INFO_PANEL_EXTENDER;
    @GameRegistry.ObjectHolder(value="worldcontrol:info_panel_extender_advanced")
    public static Block INFO_PANEL_EXTENDER_ADVANCED;
    @GameRegistry.ObjectHolder(value="worldcontrol:time_card")
    public static Item TIME_CARD;
    @GameRegistry.ObjectHolder(value="worldcontrol:image_card")
    public static Item IMAGE_CARD;

    public static void addBlocks(Block ... blocks) {
        Collections.addAll(BLOCKS, blocks);
    }

    public static void addItems(Item ... items) {
        Collections.addAll(ITEMS, items);
    }

    public static void preInit() {
        WCContent.addItems(new ItemThermometer(), new ItemCardTime(), new ItemRemotePanel(), new ItemFluidCard(), new ItemFluidKit(), new ItemForgeEnergyCard(), new ItemForgeEnergyKit(), new ItemUpgrade(), new ItemImageCard());
        WCContent.addBlocks(new BlockIndustrialAlarm(), new BlockHowlerAlarm(), new BlockInfoPanel(Material.field_151573_f, "info_panel", false), new BlockInfoPanelExtender("info_panel_extender", false), new BlockAdvancedInfoPanel());
        GameRegistry.registerTileEntity(TileEntityHowlerAlarm.class, (String)"worldcontrol:howleralarm");
        GameRegistry.registerTileEntity(TileEntityInfoPanel.class, (String)"worldcontrol:infopanel");
        GameRegistry.registerTileEntity(TileEntityInfoPanelExtender.class, (String)"worldcontrol:infopanelext");
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        BLOCKS.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        BLOCKS.stream().filter(b -> b instanceof IItemBlockFactory).map(b -> (Block)((IItemBlockFactory)b)).forEach(b -> event.getRegistry().register((IForgeRegistryEntry)((IItemBlockFactory)b).createItemBlock()));
        ITEMS.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }
}

