/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.utils;

import net.minecraft.block.properties.PropertyBool;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RedstoneHelper {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    private static boolean isPoweredWire(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150488_af && Blocks.field_150488_af.func_176211_b(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.DOWN) > 0;
    }

    public static void checkPowered(World world, TileEntity tileentity) {
        if (world != null && tileentity != null && tileentity instanceof IRedstoneConsumer) {
            boolean powered = world.func_175640_z(tileentity.func_174877_v()) || RedstoneHelper.isPoweredWire(world, tileentity.func_174877_v().func_177982_a(1, 0, 0)) || RedstoneHelper.isPoweredWire(world, tileentity.func_174877_v().func_177982_a(-1, 0, 0)) || RedstoneHelper.isPoweredWire(world, tileentity.func_174877_v().func_177982_a(0, 0, 1)) || RedstoneHelper.isPoweredWire(world, tileentity.func_174877_v().func_177982_a(0, 0, -1));
            ((IRedstoneConsumer)tileentity).setPowered(powered);
        }
    }

    public static boolean checkPowered(IBlockAccess worlds, BlockPos pos) {
        if (worlds != null && worlds instanceof World) {
            World world = (World)worlds;
            boolean powered = world.func_175640_z(pos) || RedstoneHelper.isPoweredWire(world, pos.func_177982_a(1, 0, 0)) || RedstoneHelper.isPoweredWire(world, pos.func_177982_a(-1, 0, 0)) || RedstoneHelper.isPoweredWire(world, pos.func_177982_a(0, 0, 1)) || RedstoneHelper.isPoweredWire(world, pos.func_177982_a(0, 0, -1));
            return powered;
        }
        return false;
    }

    public static interface IRedstoneConsumer {
        public boolean getPowered();

        public void setPowered(boolean var1);
    }
}

