/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.mekanism.gas;

import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import extracells.integration.Integration;
import extracells.integration.mekanism.gas.GasInterfaceBase;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Optional;
import scala.runtime.BoxesRunTime;

public abstract class GasInterfaceBase$class {
    @Optional.Method(modid="MekanismAPI|gas")
    public static int receiveGas(GasInterfaceBase $this, EnumFacing side, GasStack stack, boolean doTransfer) {
        return $this.getGasTank(side).receive(stack, doTransfer);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static GasStack drawGas(GasInterfaceBase $this, EnumFacing side, int amount, boolean doTransfer) {
        return $this.getGasTank(side).draw(amount, doTransfer);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static boolean canDrawGas(GasInterfaceBase $this, EnumFacing side, Gas gas) {
        return $this.getGasTank(side).canDraw(gas);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static boolean canReceiveGas(GasInterfaceBase $this, EnumFacing side, Gas gas) {
        return !$this.hasFilter(AEPartLocation.fromFacing((EnumFacing)side)) && $this.getGasTank(side).canReceive(gas);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static boolean canTubeConnect(GasInterfaceBase $this, EnumFacing side) {
        return $this.isMekanismLoaded();
    }

    public static void setFilter(GasInterfaceBase $this, AEPartLocation side, Fluid fluid) {
        if (fluid == null) {
            $this.setFilter(side, "");
        } else {
            $this.setFilter(side, fluid.getName());
        }
    }

    public static boolean hasFilter(GasInterfaceBase $this, AEPartLocation side) {
        String string = $this.getFilter(side);
        Integer n = BoxesRunTime.boxToInteger((int)-1);
        return string != null ? !string.equals(n) : n != null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static int exportGas(GasInterfaceBase $this, EnumFacing side, GasStack gas, DimensionalCoord pos) {
        GasTank tank = $this.getGasTank(side);
        World world = pos.getWorld();
        if (world == null) {
            return 0;
        }
        TileEntity tile = world.func_175625_s(pos.getPos().func_177972_a(side));
        if (tile == null) {
            return 0;
        }
        if (tile instanceof IGasHandler) {
            IGasHandler gasHandler = (IGasHandler)tile;
            return gasHandler.canReceiveGas(side.func_176734_d(), gas.getGas()) ? gasHandler.receiveGas(side.func_176734_d(), gas, true) : 0;
        }
        return 0;
    }

    public static void setFluid(GasInterfaceBase $this, int _index, Fluid _fluid, EntityPlayer _player) {
        $this.setFilter(AEPartLocation.fromOrdinal((int)_index), _fluid);
    }

    public static void $init$(GasInterfaceBase $this) {
        $this.extracells$integration$mekanism$gas$GasInterfaceBase$_setter_$isMekanismLoaded_$eq(Integration.Mods.MEKANISM.isEnabled());
    }
}

