/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import extracells.models.IItemModelRegister;
import extracells.models.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluid
extends Item
implements IItemModelRegister {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, ModelManager manager) {
        manager.registerItemModel(item, i -> new ModelResourceLocation("extracells:fluid/" + ItemFluid.getFluidName(i), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            ItemStack itemStack = new ItemStack((Item)this);
            ItemFluid.setFluidName(itemStack, fluid.getName());
            subItems.add((Object)itemStack);
        }
    }

    public String func_77653_i(ItemStack stack) {
        String fluidName = ItemFluid.getFluidName(stack);
        if (fluidName.isEmpty()) {
            return "null";
        }
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid != null) {
            return fluid.getLocalizedName(new FluidStack(fluid, 1000));
        }
        return "null";
    }

    public static void setFluidName(ItemStack itemStack, String fluidName) {
        itemStack.func_77983_a("fluid", (NBTBase)new NBTTagString(fluidName));
    }

    public static String getFluidName(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return "";
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return tagCompound.func_74779_i("fluid");
    }
}

